package jaxrs.example;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jakarta.enterprise.context.control.RequestContextController;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.MediaType;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.grpc.runtime.GrpcCdiExtension;
import org.jboss.resteasy.grpc.runtime.servlet.ServletConfigWrapper;
import org.jboss.resteasy.grpc.runtime.servlet.AsyncContextImpl;
import org.jboss.resteasy.grpc.runtime.servlet.AsyncMockServletOutputStream;
import org.jboss.resteasy.grpc.runtime.servlet.GrpcHttpServletDispatcher;
import org.jboss.resteasy.grpc.runtime.servlet.HttpServletRequestImpl;
import org.jboss.resteasy.grpc.runtime.servlet.HttpServletResponseImpl;
import org.jboss.resteasy.grpc.runtime.servlet.MockServletInputStream;
import org.jboss.resteasy.grpc.runtime.servlet.MockServletOutputStream;
import org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.SseEventInputImpl;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.wildfly.grpc.GrpcService;
import javax.inject.Inject;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.ContextNotActiveException;
import com.google.protobuf.Any;
import org.jboss.resteasy.grpc.server.CC1_Server;
import jaxrs.example.CC1_proto.gInteger;
import jaxrs.example.CC1_proto.gHeader;
import jaxrs.example.CC1_proto.gCookie;
import jaxrs.example.CC1_proto.gNewCookie;
import jaxrs.example.CC1_proto.gHeader;
import jaxrs.example.CC1_proto.FormValues;
import jaxrs.example.CC1_proto.GeneralEntityMessage;
import jaxrs.example.CC1_proto.GeneralReturnMessage;
import jaxrs.example.CC1ServiceGrpc.CC1ServiceImplBase;
import jaxrs.example.CC1_proto.gEmpty;
import jaxrs.example.CC1_proto.gString;
import jaxrs.example.CC1_proto.gBoolean;
import jaxrs.example.CC1_proto.gByte;
import jaxrs.example.CC1_proto.gShort;
import jaxrs.example.CC1_proto.gInteger;
import jaxrs.example.CC1_proto.gLong;
import jaxrs.example.CC1_proto.gFloat;
import jaxrs.example.CC1_proto.gDouble;
import jaxrs.example.CC1_proto.gCharacter;
import jaxrs.example.CC1_proto.org_jboss_resteasy_example___CC7;
import jaxrs.example.CC1_proto.org_jboss_resteasy_example___CC2;
import jaxrs.example.CC1_proto.org_jboss_resteasy_example___CC4;
import jaxrs.example.CC1_proto.org_jboss_resteasy_example___CC6;

@GrpcService
public class CC1ServiceGrpcImpl extends CC1ServiceImplBase {

   private static CC1_proto.gString.Builder builder = CC1_proto.gString.newBuilder();
   private static FieldDescriptor fd = builder.getDescriptorForType().getFields().iterator().next();
   private HttpServletDispatcher servlet;
   @Inject private RequestContextController requestContextController;

   @java.lang.Override
   public void ready(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/ready", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getBoolean(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gBoolean", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGBooleanField();
         request = getHttpServletRequest(param, actualParam, "/p/boolean", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gBoolean reply = gBoolean.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGBooleanField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getBooleanWrapper(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gBoolean", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGBooleanField();
         request = getHttpServletRequest(param, actualParam, "/p/Boolean", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gBoolean reply = gBoolean.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGBooleanField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getByte(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gByte", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGByteField();
         request = getHttpServletRequest(param, actualParam, "/p/byte", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gByte reply = gByte.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGByteField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getByteWrapper(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gByte", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGByteField();
         request = getHttpServletRequest(param, actualParam, "/p/Byte", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gByte reply = gByte.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGByteField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getShort(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gShort", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGShortField();
         request = getHttpServletRequest(param, actualParam, "/p/short", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gShort reply = gShort.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGShortField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getShortWrapper(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gShort", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGShortField();
         request = getHttpServletRequest(param, actualParam, "/p/Short", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gShort reply = gShort.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGShortField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getInt(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gInteger", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGIntegerField();
         request = getHttpServletRequest(param, actualParam, "/p/int", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gInteger reply = gInteger.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGIntegerField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getInteger(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gInteger", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGIntegerField();
         request = getHttpServletRequest(param, actualParam, "/p/Integer", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gInteger reply = gInteger.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGIntegerField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getLong(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gLong", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGLongField();
         request = getHttpServletRequest(param, actualParam, "/p/long", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gLong reply = gLong.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGLongField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getLongWrapper(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gLong", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGLongField();
         request = getHttpServletRequest(param, actualParam, "/p/Long", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gLong reply = gLong.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGLongField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getFloat(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gFloat", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGFloatField();
         request = getHttpServletRequest(param, actualParam, "/p/float", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gFloat reply = gFloat.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGFloatField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getFloatWrapper(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gFloat", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGFloatField();
         request = getHttpServletRequest(param, actualParam, "/p/Float", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gFloat reply = gFloat.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGFloatField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getDouble(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gDouble", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGDoubleField();
         request = getHttpServletRequest(param, actualParam, "/p/double", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gDouble reply = gDouble.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGDoubleField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getDoubleWrapper(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gDouble", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGDoubleField();
         request = getHttpServletRequest(param, actualParam, "/p/Double", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gDouble reply = gDouble.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGDoubleField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getChar(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gCharacter", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGCharacterField();
         request = getHttpServletRequest(param, actualParam, "/p/char", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gCharacter reply = gCharacter.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGCharacterField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getCharacter(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gCharacter", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGCharacterField();
         request = getHttpServletRequest(param, actualParam, "/p/Character", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gCharacter reply = gCharacter.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGCharacterField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getString(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGStringField();
         request = getHttpServletRequest(param, actualParam, "/p/string", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getResponse(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("Any", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/response", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         Any reply = Any.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGoogleProtobufAnyField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getResponseCompletionStage(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "completionStage", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/async/cs", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         AsyncMockServletOutputStream amsos = (AsyncMockServletOutputStream) response.getOutputStream();
         amsos.await();
         ByteArrayOutputStream baos = amsos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void getCC7(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("org_jboss_resteasy_example___CC7", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/cc7", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         org_jboss_resteasy_example___CC7 reply = org_jboss_resteasy_example___CC7.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setOrgJbossResteasyExampleCC7Field(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void produces(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/produces", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void consumes(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/consumes", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void pathParams(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/path/{p1}/param/{p2}", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void queryParams(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/query", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void matrixParams(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/matrix/more", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void cookieParams(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/cookieParams", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void headerParams(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/headerParams", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void paramsList(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/params/{p1}/list/{p1}", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void paramsSet(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/params/{p1}/set/{p1}", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void paramsSortedSet(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/params/{p1}/sortedset/{p1}", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void suspend(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("Any", "suspended", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/suspend", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         AsyncMockServletOutputStream amsos = (AsyncMockServletOutputStream) response.getOutputStream();
         amsos.await();
         ByteArrayOutputStream baos = amsos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         Any reply = Any.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGoogleProtobufAnyField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void context(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/context", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void inheritance(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("org_jboss_resteasy_example___CC2", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getOrgJbossResteasyExampleCC2Field();
         request = getHttpServletRequest(param, actualParam, "/p/inheritance", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         org_jboss_resteasy_example___CC2 reply = org_jboss_resteasy_example___CC2.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setOrgJbossResteasyExampleCC2Field(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void referenceField(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("org_jboss_resteasy_example___CC4", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getOrgJbossResteasyExampleCC4Field();
         request = getHttpServletRequest(param, actualParam, "/p/reference", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         org_jboss_resteasy_example___CC4 reply = org_jboss_resteasy_example___CC4.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setOrgJbossResteasyExampleCC4Field(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void m3(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getOrgJbossResteasyExampleCC4Field();
         request = getHttpServletRequest(param, actualParam, "/p/m3", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void m4(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gBoolean", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGIntegerField();
         request = getHttpServletRequest(param, actualParam, "/p/m4", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gBoolean reply = gBoolean.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGBooleanField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void m5(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/m5", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void m7(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("org_jboss_resteasy_example___CC6", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGIntegerField();
         request = getHttpServletRequest(param, actualParam, "/p/m7", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         org_jboss_resteasy_example___CC6 reply = org_jboss_resteasy_example___CC6.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setOrgJbossResteasyExampleCC6Field(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void testServletInfo(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/servletInfo", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void serverCookies(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/server/cookies", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void serverHeaders(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/server/headers", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void servletPath(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/servletPath", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void servletParams(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGStringField();
         request = getHttpServletRequest(param, actualParam, "/p/servletParams", response, "POST", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("POST", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void jaxrsResponse(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("Any", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/jaxrsResponse", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         Any reply = Any.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGoogleProtobufAnyField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void servletResponse(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("Any", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/p/servletResponse", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         Any reply = Any.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGoogleProtobufAnyField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

   @java.lang.Override
   public void found(jaxrs.example.CC1_proto.GeneralEntityMessage param, StreamObserver<jaxrs.example.CC1_proto.GeneralReturnMessage> responseObserver) {
      HttpServletRequest request = null;
      try {
         HttpServletResponseImpl response = new HttpServletResponseImpl("gString", "sync", CC1_Server.getContext(), builder, fd);
         GeneratedMessageV3 actualParam = param.getGEmptyField();
         request = getHttpServletRequest(param, actualParam, "/q/found", response, "GET", "jaxrs.example.CC1_proto.GeneralReturnMessage");
         HttpServletDispatcher servlet = getServlet();
         activateRequestContext();
         servlet.service("GET", request, response);
         MockServletOutputStream msos = (MockServletOutputStream) response.getOutputStream();
         ByteArrayOutputStream baos = msos.getDelegate();
         ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
         gString reply = gString.parseFrom(bais);
         jaxrs.example.CC1_proto.GeneralReturnMessage.Builder grmb = createGeneralReturnMessageBuilder(response);
         grmb.setGStringField(reply);
         responseObserver.onNext(grmb.build());
      } catch (Exception e) {
         responseObserver.onError(e);
      } finally {
         responseObserver.onCompleted();
         if (requestContextController != null) {
            requestContextController.deactivate();
         }
      }
   }

//=============================  non-static methods =============================
   private void activateRequestContext() {
      if (requestContextController == null) {
         requestContextController = CDI.current().select(RequestContextController.class).get();
      }
      requestContextController.activate();
   }

//=============================  static methods =============================
   private HttpServletDispatcher getServlet() throws Exception {
      if (servlet == null) {
         synchronized(this) {
            if (servlet != null) {
               return servlet;
            }
            servlet = (HttpServletDispatcher) GrpcHttpServletDispatcher.getServlet("CC1Servlet");
         }
      }
      return servlet;
   }

   private static Map<String, List<String>> convertHeaders(Map<String, jaxrs.example.CC1_proto.gHeader> protoHeaders) {
      Map<String, List<String>> headers = new HashMap<String, List<String>>();
      for (Map.Entry<String, jaxrs.example.CC1_proto.gHeader> entry : protoHeaders.entrySet()) {
         String key = entry.getKey();
         jaxrs.example.CC1_proto.gHeader protoHeader = entry.getValue();
         List<String> values = new ArrayList<String>();
         for (int i = 0; i < protoHeader.getValuesCount(); i++) {
            values.add(protoHeader.getValues(i));
         }
         headers.put(key, values);
      }
      return headers;
   }

   private static HttpServletRequest getHttpServletRequest(jaxrs.example.CC1_proto.GeneralEntityMessage param, GeneratedMessageV3 actualParam, String path, HttpServletResponse response, String verb, String type) throws Exception {
      String url = param.getURL() == "" ? "http://localhost:8080" + path : param.getURL();
      ByteArrayInputStream bais = new ByteArrayInputStream(actualParam.toByteArray());
      MockServletInputStream msis = new MockServletInputStream(bais);
      Map<String, List<String>> headers = convertHeaders(param.getHeadersMap());
      Cookie[] cookies = convertCookies(param.getCookiesList());
//      ServletContext servletContext = org.jboss.resteasy.grpc.servlet.GrpcHttpServletDispatcher.getServletContext("CC1Servlet");
      ServletContext servletContext = CC1_Server.getServletContext();
      HttpServletRequestImpl request = new HttpServletRequestImpl();
      request.setServletResponse(response);
      request.setServletContext(servletContext);
      request.setUri(url);
      request.setPath(path);
      request.setContextPath(servletContext.getContextPath());
      request.setMethod(verb);
      request.setInputStream(msis);
      request.setReturnType(type);
      request.setHeaders(headers);
      request.setCookies(cookies);
      request.setFormParameters(extractFormData(param));
      jaxrs.example.CC1_proto.ServletInfo servletInfo = param.getServletInfo();
      if (servletInfo != null) {
         if (servletInfo.getCharacterEncoding() != null) {
            request.setCharacterEncoding(servletInfo.getCharacterEncoding());
         }
         if (servletInfo.getClientAddress() != null) {
            request.setRemoteAddr(servletInfo.getClientAddress());
         }
         if (servletInfo.getClientHost() != null) {
            request.setRemoteHost(servletInfo.getClientHost());
         }
         if (servletInfo.getClientPort() != -1) {
            request.setRemotePort(servletInfo.getClientPort());
         }
      }
      return request;
   }

   private static jakarta.servlet.http.Cookie[] convertCookies(List<jaxrs.example.CC1_proto.gCookie> cookieList) {
      jakarta.servlet.http.Cookie[] cookieArray = new jakarta.servlet.http.Cookie[cookieList.size()];
      int i = 0;
      for (Iterator<jaxrs.example.CC1_proto.gCookie> it = cookieList.iterator(); it.hasNext(); ) {
         jaxrs.example.CC1_proto.gCookie protoCookie = it.next();
         jakarta.servlet.http.Cookie cookie = new jakarta.servlet.http.Cookie(protoCookie.getName(), protoCookie.getValue());
         cookie.setVersion(protoCookie.getVersion());
         cookie.setPath(protoCookie.getPath());
         cookie.setDomain(protoCookie.getDomain());
         cookieArray[i++] = cookie;
      }
      return cookieArray;
   }

   private static Map<String, String[]> extractFormData(GeneralEntityMessage param) {
      if (!param.hasFormField()) {
         return null;
      }
      Map<String, String[]> formParams = new HashMap<String, String[]>();
      Map<String, FormValues> map = param.getFormField().getFormMapFieldMap();
      for (Map.Entry<String, FormValues> entry : map.entrySet()) {
         String[] values = new String[entry.getValue().getFormValuesFieldCount()];
         for (int i = 0; i < entry.getValue().getFormValuesFieldCount(); i++) {
            values[i] = entry.getValue().getFormValuesField(i);
         }
         formParams.put(entry.getKey(), values);
      }
      return formParams;
   }

   private static GeneralReturnMessage.Builder createGeneralReturnMessageBuilder(HttpServletResponseImpl response) throws ParseException {
      GeneralReturnMessage.Builder grmBuilder = GeneralReturnMessage.newBuilder();
      gNewCookie.Builder cookieBuilder = gNewCookie.newBuilder();
      if (!response.getHeaderNames().isEmpty()) {
         gHeader.Builder headerBuilder = gHeader.newBuilder();
         for (String headerName : response.getHeaderNames()) {
            if ("Set-Cookie".equals(headerName)) {
               Collection<String> cookies = response.getHeaders("Set-Cookie");
               for (String s : cookies) {
                  grmBuilder.addCookies(parseNewCookie(cookieBuilder, s));
                  cookieBuilder.clear();
               }
            } else {
               for (String value : response.getHeaders(headerName)) {
                   headerBuilder.addValues(value);
               }
            grmBuilder.putHeaders(headerName, headerBuilder.build());
            headerBuilder.clear();
            }
         }
      }
      if (!response.getCookies().isEmpty()) {
         for (Cookie cookie : response.getCookies()) {
            cookieBuilder
               .setMaxAge(cookie.getMaxAge())
               .setVersion(cookie.getVersion())
               ;
            if (cookie.getComment() != null) {
               cookieBuilder.setComment(cookie.getComment());
            }
            if (cookie.getDomain() != null) {
               cookieBuilder.setDomain(cookie.getDomain());
            }
            if (cookie.getName() != null) {
               cookieBuilder.setName(cookie.getName());
            }
            if (cookie.getPath() != null) {
               cookieBuilder.setPath(cookie.getPath());
            }
            if (cookie.getValue() != null) {
               cookieBuilder.setValue(cookie.getValue());
            }
            if (cookie.getSecure()) {
               cookieBuilder.setSecure(true);
            }
            if (cookie.isHttpOnly()) {
               cookieBuilder.setHttpOnly(true);
            }
            grmBuilder.addCookies(cookieBuilder.build());
            cookieBuilder.clear();
         }
      }
      grmBuilder.setStatus(gInteger.newBuilder().setValue(response.getStatus()).build());
      return grmBuilder;
   }

   private static gNewCookie parseNewCookie(gNewCookie.Builder ncb, String s) throws ParseException {
      String[] fields = s.split(";");
      for (String field : fields) {
         String[] subfields = field.split("=");
         switch (subfields[0].strip()) {
            case "Domain":
               ncb.setDomain(subfields[1].trim());
               break;
            case "Path":
               ncb.setPath(subfields[1].trim());
               break;
            case "Version":
               ncb.setVersion(Integer.valueOf(subfields[1].trim()));
               break;
            case "Comment":
               ncb.setComment(subfields[1].trim());
               break;
            case "Expires":
               DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, DD-MMM-yyyy HH:mm:ss zzz");
               ZonedDateTime zdt = ZonedDateTime.parse(subfields[1].trim(), formatter);
               ncb.setExpiry(Timestamp.newBuilder().setSeconds(zdt.toEpochSecond()));
               break;
            case "HttpOnly":
               ncb.setHttpOnly(true);
               break;
            case "Max-Age":
               ncb.setMaxAge(Integer.valueOf(subfields[1].trim()));
               break;
            case "SameSite":
               ncb.setSameSite(gNewCookie.SameSite.valueOf(subfields[1].trim()));
               break;
            case "Secure":
               ncb.setSecure(true);
               break;
            default:
               ncb.setName(subfields[0].trim());
               ncb.setValue(subfields[1].trim());
         }
      }
      return ncb.build();
   }
}
