/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.grpc.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jaxrs.example.CC1ServiceGrpcImpl;

@Path(value="grpcserver")
public class CC1_Server {
    private static final Logger logger = Logger.getLogger(CC1_Server.class.getName());
    private static ServletConfig servletConfig;
    private static ServletContext servletContext;
    private static int PORT;
    private Server server;

    @Path(value="getservletcontext")
    @GET
    public ServletContext getServletContext(@Context HttpServletRequest request) {
        return request.getServletContext();
    }

    public static ServletConfig getServletConfig() {
        return servletConfig;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    @Path(value="start")
    @GET
    public String startGRPC(@Context ServletConfig servletConfig) throws Exception {
        CC1_Server.servletConfig = servletConfig;
        servletContext = servletConfig.getServletContext();
        final CC1_Server server = new CC1_Server();
        new Thread(){

            @Override
            public void run() {
                try {
                    if (System.getSecurityManager() == null) {
                        server.start();
                    } else {
                        AccessController.doPrivileged(() -> {
                            server.start();
                            return null;
                        });
                    }
                    System.out.println("started gRPC server on port " + PORT);
                    server.blockUntilShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        return "Starting gRPC server on port " + PORT;
    }

    @Path(value="ready")
    @GET
    public String ready() {
        System.out.println("gRPC server ready");
        return "ready";
    }

    @Path(value="context")
    @GET
    public String startContext(@Context HttpServletRequest request) throws Exception {
        servletContext = request.getServletContext();
        CC1_Server server = new CC1_Server();
        return "Got " + this + " servletContext";
    }

    @Path(value="stop")
    @GET
    public void stopGRPC() throws Exception {
        this.stop();
    }

    public static ServletContext getContext() {
        return servletContext;
    }

    private void start() throws Exception {
        if (System.getSecurityManager() == null) {
            this.server = ServerBuilder.forPort((int)PORT).addService((BindableService)new CC1ServiceGrpcImpl()).build().start();
        } else {
            AccessController.doPrivileged(() -> {
                this.server = ServerBuilder.forPort((int)PORT).addService((BindableService)new CC1ServiceGrpcImpl()).build().start();
                return this.server;
            });
        }
        logger.info("Server started, listening on " + PORT);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                try {
                    CC1_Server.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                System.err.println("*** server shut down");
            }
        });
    }

    private void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws Exception, InterruptedException {
        CC1_Server server = new CC1_Server();
        server.start();
        server.blockUntilShutdown();
    }

    static {
        PORT = 8082;
    }
}

