/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.grpc.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jaxrs.example.CC1ServiceGrpcImpl;

@Path(value="grpcserver")
public class CC1_Server {
    private static final Logger logger = Logger.getLogger(CC1_Server.class.getName());
    private static ServletContext context;
    private static int PORT;
    private Server server;

    @Path(value="getservletcontext")
    @GET
    public ServletContext getServletContext(@Context HttpServletRequest request) {
        return request.getServletContext();
    }

    @Path(value="start")
    @GET
    public String startGRPC(@Context HttpServletRequest request) throws Exception {
        context = request.getServletContext();
        final CC1_Server server = new CC1_Server();
        new Thread(){

            @Override
            public void run() {
                try {
                    server.start();
                    System.out.println("started gRPC server on port " + PORT);
                    server.blockUntilShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        return "Starting gRPC server on port " + PORT;
    }

    @Path(value="ready")
    @GET
    public String ready() {
        System.out.println("gRPC server ready");
        return "ready";
    }

    @Path(value="context")
    @GET
    public String startContext(@Context HttpServletRequest request) throws Exception {
        System.out.println(request.getClass());
        context = request.getServletContext();
        CC1_Server server = new CC1_Server();
        System.out.println("context: " + context);
        return "Got " + this + " context";
    }

    @Path(value="stop")
    @GET
    public void stopGRPC() throws Exception {
        this.stop();
    }

    public static ServletContext getContext() {
        System.out.println("returning " + context);
        return context;
    }

    private void start() throws IOException {
        this.server = ServerBuilder.forPort((int)PORT).addService((BindableService)new CC1ServiceGrpcImpl()).build().start();
        logger.info("Server started, listening on " + PORT);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                try {
                    CC1_Server.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                System.err.println("*** server shut down");
            }
        });
    }

    private void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        CC1_Server server = new CC1_Server();
        server.start();
        server.blockUntilShutdown();
    }

    static {
        PORT = 8082;
    }
}

