package org.jboss.resteasy.grpc.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet(value = "/grpcServlet")
public class CC1_GrpcServlet extends HttpServlet {

   private static final long serialVersionUID = -7323100224345687064L;
   private static final Map<String, Servlet> servletMap = new HashMap<String, Servlet>();
   private static final Map<Servlet, ServletContext> servletContextMap = new HashMap<Servlet, ServletContext>();
   private String name;

   @Override
   public void init(ServletConfig servletConfig) throws ServletException {
      super.init(servletConfig);
      name = servletConfig.getServletName();
      addServlet(name, this, servletConfig.getServletContext());
   }

   @Override
   public void destroy() {
      super.destroy();
      removeServlet(name);
   }

   public static void addServlet(String name, Servlet servlet, ServletContext servletContext) {
      servletMap.put(name, servlet);
      servletContextMap.put(servlet, servletContext);
   }

   public static void removeServlet(String name) {
      servletContextMap.remove(servletMap.get(name));
      servletMap.remove(name);
   }

   public static Servlet getServlet(String name) {
      return servletMap.get(name);
   }

   public static ServletContext getServletContext(String servletName) {
      Servlet servlet = servletMap.get(servletName);
      if (servlet == null) {
         return null;
      }
      return servletContextMap.get(servlet);
   }

   public static ServletContext getServletContext(Servlet servlet) {
      return servletContextMap.get(servlet);
   }

   @Override
   protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
      // no op
   }

   @Override
   protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
      // no op
   }
   
}