/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.example;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.example.CC1;
import org.jboss.resteasy.example.CC2;
import org.jboss.resteasy.example.CC4;
import org.jboss.resteasy.example.CC5;
import org.jboss.resteasy.example.CC6;
import org.jboss.resteasy.example.CC7;

@Path(value="p")
public class CC1 {
    @Path(value="ready")
    @GET
    public String ready() {
        System.out.println("gRPC server ready");
        return "ready";
    }

    @Path(value="boolean")
    @POST
    public boolean getBoolean(boolean b) {
        return !b;
    }

    @Path(value="Boolean")
    @POST
    public Boolean getBooleanWrapper(Boolean b) {
        return b == false;
    }

    @Path(value="byte")
    @POST
    public byte getByte(byte b) {
        int i = b + 1;
        return (byte)i;
    }

    @Path(value="Byte")
    @POST
    public Byte getByteWrapper(Byte b) {
        return (byte)(b + 1);
    }

    @Path(value="short")
    @POST
    public short getShort(short n) {
        int i = n + 1;
        return (short)i;
    }

    @Path(value="Short")
    @POST
    public Short getShortWrapper(Short n) {
        return (short)(n + 1);
    }

    @Path(value="int")
    @POST
    public int getInt(int n) {
        return n + 1;
    }

    @Path(value="Integer")
    @POST
    public Integer getInteger(Integer n) {
        return n + 1;
    }

    @Path(value="long")
    @POST
    public long getLong(long n) {
        return n + 1L;
    }

    @Path(value="Long")
    @POST
    public Long getLongWrapper(Long n) {
        return n + 1L;
    }

    @Path(value="float")
    @POST
    public float getFloat(float f) {
        return Float.valueOf(f + 1.0f).floatValue();
    }

    @Path(value="Float")
    @POST
    public Float getFloatWrapper(Float f) {
        return Float.valueOf(f.floatValue() + 1.0f);
    }

    @Path(value="double")
    @POST
    public double getDouble(double d) {
        return d + 1.0;
    }

    @Path(value="Double")
    @POST
    public Double getDoubleWrapper(Double d) {
        return (double)d.floatValue() + 1.0;
    }

    @Path(value="char")
    @POST
    public char getChar(char c) {
        return Character.toUpperCase(c);
    }

    @Path(value="Character")
    @POST
    public Character getCharacter(Character c) {
        return Character.valueOf(Character.toUpperCase(c.charValue()));
    }

    @Path(value="string")
    @POST
    public String getString(String s) {
        return s.toUpperCase();
    }

    @Path(value="response")
    @GET
    public Response getResponse() {
        CC7 cc7 = new CC7("cc7", 11);
        return Response.ok((Object)cc7).build();
    }

    @Path(value="async/cs")
    @GET
    public CompletionStage<String> getResponseCompletionStage() {
        CompletableFuture<String> response = new CompletableFuture<String>();
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        return response;
    }

    @Path(value="cc7")
    @GET
    public CC7 getCC7() {
        CC7 cc7 = new CC7("cc7", 11);
        return cc7;
    }

    @Path(value="produces")
    @Produces(value={"abc/xyz"})
    @GET
    public String produces() {
        return "produces";
    }

    @Path(value="consumes")
    @Consumes(value={"xyz/abc"})
    @GET
    public String consumes() {
        return "consumes";
    }

    @Path(value="path/{p1}/param/{p2}")
    @GET
    public String pathParams(@PathParam(value="p1") String p1, @PathParam(value="p2") String p2) {
        return "x" + p1 + "y" + p2 + "z";
    }

    @Path(value="query")
    @GET
    public String queryParams(@QueryParam(value="q1") String q1, @QueryParam(value="q2") String q2) {
        return "x" + q1 + "y" + q2 + "z";
    }

    @Path(value="matrix/more")
    @GET
    public String matrixParams(@MatrixParam(value="m1") String m1, @MatrixParam(value="m2") String m2, @MatrixParam(value="m3") String m3) {
        return "w" + m1 + "x" + m2 + "y" + m3 + "z";
    }

    @Path(value="cookieParams")
    @GET
    public String cookieParams(@CookieParam(value="c1") Cookie c1, @CookieParam(value="c2") Cookie c2) {
        return "x" + this.cookieStringify(c1) + "y" + this.cookieStringify(c2) + "z";
    }

    private String cookieStringify(Cookie c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getName()).append("=").append(c.getValue()).append(";").append(c.getDomain()).append(",").append(c.getPath()).append(",").append(c.getVersion());
        return sb.toString();
    }

    @Path(value="headerParams")
    @GET
    public String headerParams(@HeaderParam(value="h1") String h1, @HeaderParam(value="h2") String h2) {
        return "x" + h1 + "y" + h2 + "z";
    }

    @Path(value="params/{p1}/list/{p1}")
    @GET
    public String paramsList(@HeaderParam(value="h1") List<String> headerList, @MatrixParam(value="m1") List<String> matrixList, @PathParam(value="p1") List<String> pathList, @QueryParam(value="q1") List<String> queryList) {
        StringBuilder sb = new StringBuilder();
        for (String s : headerList) {
            sb.append(s);
        }
        for (String s : matrixList) {
            sb.append(s);
        }
        for (String s : pathList) {
            sb.append(s);
        }
        for (String s : queryList) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Path(value="params/{p1}/set/{p1}")
    @GET
    public String paramsSet(@HeaderParam(value="h1") Set<String> headerSet, @MatrixParam(value="m1") Set<String> matrixSet, @PathParam(value="p1") Set<String> pathSet, @QueryParam(value="q1") Set<String> querySet) {
        ArrayList<String> headerList = new ArrayList<String>(headerSet);
        ArrayList<String> matrixList = new ArrayList<String>(matrixSet);
        ArrayList<String> pathList = new ArrayList<String>(pathSet);
        ArrayList<String> queryList = new ArrayList<String>(querySet);
        Collections.sort(headerList);
        Collections.sort(matrixList);
        Collections.sort(pathList);
        Collections.sort(queryList);
        StringBuilder sb = new StringBuilder();
        for (String s : headerList) {
            sb.append(s);
        }
        for (String s : matrixList) {
            sb.append(s);
        }
        for (String s : pathList) {
            sb.append(s);
        }
        for (String s : queryList) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Path(value="params/{p1}/sortedset/{p1}")
    @GET
    public String paramsSortedSet(@HeaderParam(value="h1") SortedSet<String> headerSet, @MatrixParam(value="m1") SortedSet<String> matrixSet, @PathParam(value="p1") SortedSet<String> pathSet, @QueryParam(value="q1") SortedSet<String> querySet) {
        StringBuilder sb = new StringBuilder();
        for (String s : headerSet) {
            sb.append(s);
        }
        for (String s : matrixSet) {
            sb.append(s);
        }
        for (String s : pathSet) {
            sb.append(s);
        }
        for (String s : querySet) {
            sb.append(s);
        }
        return sb.toString();
    }

    @GET
    @Path(value="suspend")
    public void suspend(@Suspended AsyncResponse response) {
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
    }

    @GET
    @Path(value="context")
    public String context(@Context HttpServletRequest request) {
        String contextPath = request.getServletContext().getContextPath();
        return contextPath;
    }

    @Path(value="inheritance")
    @POST
    public CC2 inheritance(CC2 cc2) {
        return new CC2("x" + cc2.s + "y", cc2.j + 1);
    }

    @Path(value="reference")
    @POST
    public CC4 referenceField(CC4 cc4) {
        CC5 newCC5 = new CC5(cc4.cc5.k + 1);
        CC4 newCC4 = new CC4("x" + cc4.s + "y", newCC5);
        return newCC4;
    }

    String m2(String s) {
        return "x";
    }

    @Path(value="m3")
    @POST
    public String m3(CC4 cc4) {
        return "x";
    }

    @Path(value="m4")
    @POST
    public boolean m4(int i) {
        return true;
    }

    @Path(value="m5")
    @GET
    public String m5() {
        return "m5";
    }

    @Path(value="m7")
    @POST
    public CC6 m7(int i) {
        CC7 cc7 = new CC7("m7", i + 1);
        CC6 cc6 = new CC6(i + 2, cc7);
        return cc6;
    }

    @Path(value="servletInfo")
    @POST
    public String testServletInfo(@Context HttpServletRequest request) {
        String characterEncoding = request.getCharacterEncoding().toUpperCase();
        Object remoteAddr = request.getRemoteAddr();
        remoteAddr = ((String)remoteAddr).substring(0, ((String)remoteAddr).lastIndexOf(".") + 1) + "5";
        String remoteHost = request.getRemoteHost().toUpperCase();
        int remotePort = request.getRemotePort() + 1;
        return characterEncoding + "|" + (String)remoteAddr + "|" + remoteHost + "|" + remotePort;
    }
}

