/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javassist.bytecode.ClassFile;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectDeployer
extends AbstractVFSRealDeployer {
    private static final String AOP_JAR_SUFFIX = ".aop";
    private static final String AOP_DD_SUFFIX = "-aop.xml";
    private AspectManager aspectManager;

    public AspectDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
    }

    public AspectManager getAspectManager() {
        return this.aspectManager;
    }

    public void setAspectManager(AspectManager aspectManager) {
        this.aspectManager = aspectManager;
    }

    public void create() {
        if (this.aspectManager == null) {
            throw new IllegalStateException("No aspect manager configured");
        }
    }

    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        List files = unit.getMetaDataFiles(null, AOP_DD_SUFFIX);
        if (this.isAopArchiveOrFolder(unit)) {
            this.deployAnnotations(unit);
        }
        if (files.size() > 0) {
            this.deployXml(unit, files);
        }
    }

    public void undeploy(VFSDeploymentUnit unit) {
        List files = unit.getMetaDataFiles(null, AOP_DD_SUFFIX);
        if (this.isAopArchiveOrFolder(unit)) {
            this.undeployAnnotations(unit);
        }
        if (files.size() > 0) {
            this.undeployXml(unit, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployXml(VFSDeploymentUnit unit, List<VirtualFile> files) throws DeploymentException {
        ClassLoader scl = this.getScopedClassLoader(unit);
        if (scl != null) {
            this.log.info((Object)("AOP deployment is scoped using classloader " + scl));
        }
        ArrayList<VirtualFile> deployedFiles = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile vf : files) {
            deployedFiles.add(vf);
            try {
                this.log.debug((Object)("deploying: " + vf.toURL()));
                InputStream is = vf.openStream();
                try {
                    Document doc = AspectXmlLoader.loadDocument((InputStream)is);
                    AspectXmlLoader loader = new AspectXmlLoader();
                    if (scl != null) {
                        loader.setManager(AspectManager.instance((ClassLoader)scl));
                        loader.setClassLoader(scl);
                    } else {
                        loader.setManager(AspectManager.instance());
                    }
                    loader.deployXML(doc, vf.toURL(), scl);
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                for (int i = deployedFiles.size() - 1; i >= 0; --i) {
                    this.undeployXml(scl, (VirtualFile)deployedFiles.get(i));
                }
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying xml " + vf.getName()), (Throwable)e);
            }
        }
    }

    private void undeployXml(VFSDeploymentUnit unit, List<VirtualFile> files) {
        ClassLoader scl = this.getScopedClassLoader(unit);
        for (VirtualFile vf : files) {
            this.undeployXml(scl, vf);
        }
        this.aspectManager.unregisterClassLoader(unit.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployXml(ClassLoader scl, VirtualFile vf) {
        try {
            this.log.debug((Object)("undeploying: " + vf.toURL()));
            InputStream is = vf.openStream();
            try {
                Document doc = AspectXmlLoader.loadDocument((InputStream)is);
                AspectXmlLoader loader = new AspectXmlLoader();
                AspectManager manager = scl != null ? AspectManager.instance((ClassLoader)scl) : this.aspectManager;
                loader.setManager(manager);
                loader.undeployXML(doc, vf.toURL());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error undeploying xml " + vf.getName()), (Throwable)e);
        }
    }

    private void deployAnnotations(VFSDeploymentUnit unit) throws DeploymentException {
        ClassLoader scl = this.getScopedClassLoader(unit);
        if (scl != null) {
            this.log.info((Object)("AOP deployment is scoped using classloader " + scl));
        }
        AspectAnnotationLoader loader = this.getAnnotationLoader(scl);
        List<VirtualFile> files = this.getClasses(unit);
        ArrayList deployedFiles = new ArrayList(files.size());
        for (VirtualFile file : files) {
            try {
                ClassFile cf = this.loadClassFile(file);
                this.log.debug((Object)("Deploying possibly annotated class " + cf.getName()));
                loader.deployClassFile(cf);
            }
            catch (Exception e) {
                for (int i = deployedFiles.size(); i >= 0; --i) {
                    this.undeployAnnotation(loader, (VirtualFile)deployedFiles.get(i));
                }
                throw new DeploymentException("Error reading annotations for " + file, (Throwable)e);
            }
        }
    }

    private void undeployAnnotations(VFSDeploymentUnit unit) {
        ClassLoader scl = this.getScopedClassLoader(unit);
        AspectAnnotationLoader loader = this.getAnnotationLoader(scl);
        List<VirtualFile> files = this.getClasses(unit);
        for (VirtualFile file : files) {
            this.undeployAnnotation(loader, file);
        }
    }

    private void undeployAnnotation(AspectAnnotationLoader loader, VirtualFile file) {
        try {
            ClassFile cf = this.loadClassFile(file);
            this.log.debug((Object)("Undeploying possibly annotated class " + cf.getName()));
            loader.undeployClassFile(cf);
        }
        catch (Exception e) {
            this.log.warn((Object)("Error reading annotations for " + file), (Throwable)e);
        }
    }

    private AspectAnnotationLoader getAnnotationLoader(ClassLoader scl) {
        AspectManager manager = scl != null ? AspectManager.instance((ClassLoader)scl) : AspectManager.instance();
        AspectAnnotationLoader loader = new AspectAnnotationLoader(manager);
        loader.setClassLoader(scl);
        return loader;
    }

    private ClassFile loadClassFile(VirtualFile file) {
        FilterInputStream din = null;
        ClassFile cf = null;
        try {
            InputStream in = file.openStream();
            din = new DataInputStream(new BufferedInputStream(in));
            cf = new ClassFile((DataInputStream)din);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + file, e);
        }
        finally {
            try {
                din.close();
            }
            catch (IOException ignored) {}
        }
        return cf;
    }

    private List<VirtualFile> getClasses(VFSDeploymentUnit unit) {
        VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        ClassFileFilter filter = new ClassFileFilter();
        SuffixesExcludeFilter noJars = new SuffixesExcludeFilter((Collection)JarUtils.getSuffixes());
        va.setRecurseFilter((VirtualFileFilter)noJars);
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor((VirtualFileFilter)filter, va);
        for (VirtualFile vf : unit.getClassPath()) {
            try {
                vf.visit((VirtualFileVisitor)visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return visitor.getMatched();
    }

    private boolean isAopArchiveOrFolder(VFSDeploymentUnit unit) {
        String name = unit.getName();
        int index = name.length();
        if (name.charAt(name.length() - 1) == '/') {
            --index;
        }
        if (name.charAt(name.length() - 2) == '!') {
            --index;
        }
        String realName = index == name.length() ? name : name.substring(0, index);
        return realName.endsWith(AOP_JAR_SUFFIX);
    }

    private ClassLoader getScopedClassLoader(VFSDeploymentUnit unit) {
        AspectManager.instance();
        AOPClassLoaderScopingPolicy policy = AspectManager.getClassLoaderScopingPolicy();
        ClassLoader cl = unit.getClassLoader();
        if (policy != null && policy.isScoped(cl)) {
            return unit.getClassLoader();
        }
        return null;
    }

    private static class ClassFileFilter
    implements VirtualFileFilter {
        private ClassFileFilter() {
        }

        public boolean accepts(VirtualFile file) {
            try {
                return file.isLeaf() && file.getName().endsWith(".class");
            }
            catch (IOException e) {
                throw new RuntimeException("Error visiting file: " + file.getName(), e);
            }
        }
    }
}

