/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss4;

import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.asintegration.jboss4.ScopedRepositoryClassLoaderHelper;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.aop.domain.DomainInitializer;
import org.jboss.aop.domain.ScopedRepositoryClassLoaderDomain;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.RepositoryClassLoader;

public class RepositoryClassLoaderScopingPolicy
implements AOPClassLoaderScopingPolicy,
DomainInitializer {
    Logger log = Logger.getLogger(RepositoryClassLoaderScopingPolicy.class);
    private Map<Object, Domain> scopedClassLoaderDomains = new WeakHashMap<Object, Domain>();

    public Domain initializeDomain(VFSDeploymentUnit unit) {
        ClassLoader loader = unit.getClassLoader();
        Domain domain = this.getDomain(loader, AspectManager.getTopLevelAspectManager());
        AspectManager.instance().registerClassLoader(loader);
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Domain getDomain(ClassLoader classLoader, AspectManager parent) {
        ClassLoader scopedClassLoader = this.ifScopedDeploymentGetScopedParentUclForCL(classLoader);
        if (scopedClassLoader != null) {
            Domain scopedManager = null;
            Map map = AOPClassPoolRepository.getInstance().getRegisteredCLs();
            synchronized (map) {
                Object loaderRepository = this.getLoaderRepository(classLoader);
                scopedManager = this.scopedClassLoaderDomains.get(loaderRepository);
                if (scopedManager != null && !scopedManager.isValid()) {
                    this.scopedClassLoaderDomains.remove(loaderRepository);
                    scopedManager = null;
                }
                if (scopedManager == null) {
                    scopedManager = this.getScopedClassLoaderDomain(scopedClassLoader, parent);
                    this.log.debug((Object)("Created domain " + scopedManager + " for scoped deployment on: " + classLoader + "; identifying scoped ucl: " + scopedClassLoader));
                    scopedManager.setInheritsBindings(true);
                    scopedManager.setInheritsDeclarations(true);
                    this.scopedClassLoaderDomains.put(loaderRepository, scopedManager);
                }
                return scopedManager;
            }
        }
        return null;
    }

    public Domain getTopLevelDomain(AspectManager parent) {
        ClassLoader classLoader = this.getTopLevelJBossClassLoader();
        return this.getDomain(classLoader, parent);
    }

    private ClassLoader ifScopedDeploymentGetScopedParentUclForCL(ClassLoader loader) {
        for (ClassLoader parent = loader; parent != null; parent = parent.getParent()) {
            if (ScopedRepositoryClassLoaderHelper.isScopedClassLoader(parent)) {
                return parent;
            }
            if (!(parent instanceof RepositoryClassLoader)) continue;
            return null;
        }
        return null;
    }

    private ClassLoader getTopLevelJBossClassLoader() {
        RepositoryClassLoader topRcl = null;
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof RepositoryClassLoader)) continue;
            topRcl = (RepositoryClassLoader)loader;
        }
        return topRcl;
    }

    private Domain getScopedClassLoaderDomain(ClassLoader cl, AspectManager parent) {
        boolean parentDelegation = true;
        if (cl instanceof RepositoryClassLoader) {
            HeirarchicalLoaderRepository3 repository = (HeirarchicalLoaderRepository3)((RepositoryClassLoader)cl).getLoaderRepository();
            parentDelegation = repository.getUseParentFirst();
        }
        String name = String.valueOf(System.identityHashCode(cl));
        return new ScopedRepositoryClassLoaderDomain(cl, name, parentDelegation, parent, false);
    }

    private Object getLoaderRepository(ClassLoader loader) {
        ClassLoader cl = this.ifScopedDeploymentGetScopedParentUclForCL(loader);
        if (cl != null) {
            return ((RepositoryClassLoader)cl).getLoaderRepository();
        }
        return null;
    }
}

