/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.InvalidAdviceException;
import org.jboss.aop.advice.NoMatchingAdviceException;
import org.jboss.aop.advice.annotation.AdviceInfo;
import org.jboss.aop.advice.annotation.AnnotatedParameterAdviceInfo;
import org.jboss.aop.advice.annotation.ParameterAnnotationRule;
import org.jboss.aop.util.ReflectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceMethodFactory {
    public static final AdviceMethodFactory BEFORE = new AdviceMethodFactory(null, new ParameterAnnotationRule[]{ParameterAnnotationRule.JOIN_POINT}, ReturnType.VOID, null);
    public static final AdviceMethodFactory AFTER = new AdviceMethodFactory(null, new ParameterAnnotationRule[]{ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.RETURN}, ReturnType.ANY, null);
    public static final AdviceMethodFactory THROWING = new AdviceMethodFactory(null, new ParameterAnnotationRule[]{ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.MANDATORY_THROWN}, ReturnType.VOID, null);
    public static final AdviceMethodFactory FINALLY = new AdviceMethodFactory(null, new ParameterAnnotationRule[]{ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.RETURN, ParameterAnnotationRule.OPTIONAL_THROWN}, ReturnType.ANY, new int[][]{{1, 2}});
    public static final AdviceMethodFactory AROUND = new AdviceMethodFactory(new AdviceSignatureRule(){

        public boolean applies(Method method) {
            Annotation[][] annotations = method.getParameterAnnotations();
            if (annotations.length != 1) {
                return false;
            }
            for (Annotation annotation : annotations[0]) {
                if (annotation.annotationType().getPackage() != AdviceMethodFactory.class.getPackage()) continue;
                return false;
            }
            if (method.getReturnType() != Object.class) {
                throw new InvalidAdviceException("Method '" + method + "' does not match default around signature because it returns " + method.getReturnType() + " instead of java.lang.Object");
            }
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (exceptionType != Throwable.class) continue;
                return true;
            }
            throw new InvalidAdviceException("Method '" + method + "' does not match default around signature because it does not throw java.lang.Throwable");
        }

        public AdviceInfo getAdviceInfo(Method method) {
            return new AdviceInfo(method, 2000){

                public boolean matches(AdviceMethodProperties properties, ReturnType adviceReturn) {
                    if (this.parameterTypes[0].isAssignableFrom(properties.getInvocationType())) {
                        return true;
                    }
                    if (AspectManager.verbose) {
                        AdviceMethodFactory.appendNewMatchingMessage(this.method, "argument 0 is not assignable from ");
                        AdviceMethodFactory.appendMatchingMessage(properties.getInvocationType());
                    }
                    return false;
                }

                public void resetMatching() {
                }

                public short getAssignabilityDegree(int typeIndex, boolean isContextRule, AdviceMethodProperties properties) {
                    return DEGREE.getAssignabilityDegree((Type)properties.getInvocationType(), (Type)this.parameterTypes[0]);
                }

                public void assignAdviceInfo(AdviceMethodProperties properties) {
                    properties.setFoundProperties(this.method, new int[]{-2});
                }
            };
        }
    }, new ParameterAnnotationRule[]{ParameterAnnotationRule.INVOCATION}, ReturnType.NOT_VOID, null);
    static final ParameterAnnotationRule[] TARGET_AVAILABLE = new ParameterAnnotationRule[]{ParameterAnnotationRule.TARGET, ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG};
    static final int[][] TA_INCOMPATIBILITY = new int[][]{{1, 2}};
    static final ParameterAnnotationRule[] TARGET_CALLER_AVAILABLE = new ParameterAnnotationRule[]{ParameterAnnotationRule.TARGET, ParameterAnnotationRule.CALLER, ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG};
    static final int[][] TCA_INCOMPATIBILITY = new int[][]{{2, 3}};
    private static StringBuffer adviceMatchingMessage = new StringBuffer();
    private HashMap<String, WeakHashMap<ParameterAnnotationRule[], Collection<AdviceInfo>>> adviceInfoCache;
    private ReturnType returnType;
    private AdviceSignatureRule adviceSignatureRule;
    private ParameterAnnotationRule[] rules;
    private int[][] compulsory;
    private AdviceType adviceType;

    static <T> void appendNewMatchingMessage(Method method, T message) {
        adviceMatchingMessage.append("\n  On method '");
        adviceMatchingMessage.append(method);
        adviceMatchingMessage.append("'\n    ");
        adviceMatchingMessage.append(message);
    }

    static <T> void appendMatchingMessage(T message) {
        adviceMatchingMessage.append(message);
    }

    private AdviceMethodFactory(AdviceSignatureRule adviceSignatureRule, ParameterAnnotationRule[] rules, ReturnType returnType, int[][] compulsory) {
        this.adviceSignatureRule = adviceSignatureRule;
        this.rules = rules;
        this.returnType = returnType;
        this.adviceInfoCache = new HashMap();
        this.compulsory = compulsory;
    }

    public void setAdviceType(AdviceType adviceType) {
        if (this.adviceType != null) {
            throw new RuntimeException("Unexpected call to setAdviceType method");
        }
        this.adviceType = adviceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdviceMethodProperties findAdviceMethod(AdviceMethodProperties properties) throws NoMatchingAdviceException {
        adviceMatchingMessage.delete(0, adviceMatchingMessage.length());
        ParameterAnnotationRule[] contextRules = null;
        int[][] mutuallyExclusive = null;
        switch (properties.getOptionalParameters()) {
            case TARGET: {
                contextRules = TARGET_AVAILABLE;
                mutuallyExclusive = TA_INCOMPATIBILITY;
                break;
            }
            case TARGET_CALLER: {
                contextRules = TARGET_CALLER_AVAILABLE;
                mutuallyExclusive = TCA_INCOMPATIBILITY;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected Optional Parameters Option" + (Object)((Object)properties.getOptionalParameters()));
            }
        }
        Collection<AdviceInfo> cacheCollection = this.getRankedAdvices(properties, contextRules, mutuallyExclusive);
        if (cacheCollection == null || cacheCollection.isEmpty()) {
            throw new NoMatchingAdviceException(properties, this.adviceType, adviceMatchingMessage.toString());
        }
        Collection<AdviceInfo> collection = cacheCollection;
        synchronized (collection) {
            LinkedList<AdviceInfo> rankedAdvices = new LinkedList<AdviceInfo>(cacheCollection);
            AdviceInfo bestAdvice = this.bestValidAdvice(rankedAdvices, properties, contextRules);
            if (bestAdvice == null) {
                throw new NoMatchingAdviceException(properties, this.adviceType, adviceMatchingMessage.toString());
            }
            bestAdvice.assignAdviceInfo(properties);
            properties.setAdviceOverloaded(rankedAdvices.size() > 1);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AdviceInfo> getRankedAdvices(AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules, int[][] mutuallyExclusive) {
        WeakHashMap<Object, Collection<AdviceInfo>> map;
        AbstractMap abstractMap = this.adviceInfoCache;
        synchronized (abstractMap) {
            String key = properties.getAspectClass().getName() + properties.getAdviceName();
            map = this.adviceInfoCache.get(key);
            if (map == null) {
                map = new WeakHashMap();
                this.adviceInfoCache.put(key, map);
            }
        }
        abstractMap = map;
        synchronized (abstractMap) {
            if (map.containsKey(contextRules)) {
                Collection<AdviceInfo> advices = map.get(contextRules);
                for (AdviceInfo adviceInfo : advices) {
                    adviceInfo.resetMatching();
                }
                return advices;
            }
            Method[] methods = ReflectUtils.getMethodsWithName(properties.getAspectClass(), properties.getAdviceName());
            ArrayList<AdviceInfo> rankedAdvices = new ArrayList<AdviceInfo>(methods.length);
            map.put(contextRules, rankedAdvices);
            if (methods.length == 0) {
                if (AspectManager.verbose) {
                    throw new NoMatchingAdviceException(properties, this.adviceType, ": no method named " + properties.getAdviceName() + " was found");
                }
                return null;
            }
            for (int i = 0; i < methods.length; ++i) {
                if (this.adviceSignatureRule != null && this.adviceSignatureRule.applies(methods[i])) {
                    rankedAdvices.add(this.adviceSignatureRule.getAdviceInfo(methods[i]));
                    continue;
                }
                rankedAdvices.add(new AnnotatedParameterAdviceInfo(properties, this.adviceType, methods[i], this.rules, contextRules, mutuallyExclusive, this.compulsory, this.returnType));
            }
            Collections.sort(rankedAdvices);
            return rankedAdvices;
        }
    }

    private AdviceInfo bestValidAdvice(LinkedList<AdviceInfo> rankedAdvices, AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules) {
        AdviceInfo advice;
        AdviceInfo bestAdvice = null;
        ListIterator iterator = rankedAdvices.listIterator();
        while (iterator.hasNext()) {
            advice = (AdviceInfo)iterator.next();
            if (advice.matches(properties, this.returnType)) {
                bestAdvice = advice;
                break;
            }
            iterator.remove();
        }
        switch (rankedAdvices.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return bestAdvice;
            }
        }
        while (iterator.hasNext()) {
            advice = (AdviceInfo)iterator.next();
            if (advice.getRank() == bestAdvice.getRank()) {
                if (advice.matches(properties, this.returnType)) continue;
                iterator.remove();
                continue;
            }
            iterator.previous();
            break;
        }
        if (iterator.previous() == bestAdvice) {
            return bestAdvice;
        }
        iterator.next();
        List<AdviceInfo> bestAdvices = rankedAdvices.subList(0, iterator.nextIndex());
        return this.bestMatch(bestAdvices, properties, contextRules);
    }

    AdviceInfo bestMatch(Collection<AdviceInfo> greatestRank, AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules) {
        AdviceInfo bestAdvice = this.selectBestRuleMatch(greatestRank, properties, this.rules.length, false);
        if (bestAdvice != null) {
            return bestAdvice;
        }
        bestAdvice = this.selectBestRuleMatch(greatestRank, properties, contextRules.length, true);
        if (bestAdvice != null) {
            return bestAdvice;
        }
        short bestDegree = Short.MAX_VALUE;
        if (this.returnType == ReturnType.ANY || this.returnType == ReturnType.NOT_VOID) {
            for (AdviceInfo currentAdvice : greatestRank) {
                short currentDegree = currentAdvice.getReturnAssignabilityDegree(properties);
                if (currentDegree >= bestDegree) continue;
                bestAdvice = currentAdvice;
                bestDegree = currentDegree;
            }
            return bestAdvice;
        }
        return greatestRank.iterator().next();
    }

    private AdviceInfo selectBestRuleMatch(Collection<AdviceInfo> greatestRank, AdviceMethodProperties properties, int totalRules, boolean isContextRule) {
        int bestDegree = Short.MAX_VALUE;
        ArrayList<AdviceInfo> bestAdviceList = new ArrayList<AdviceInfo>();
        for (int i = 0; i < totalRules; ++i) {
            for (AdviceInfo currentAdvice : greatestRank) {
                int currentDegree = currentAdvice.getAssignabilityDegree(i, isContextRule, properties);
                if (currentDegree < bestDegree) {
                    bestAdviceList.clear();
                    bestAdviceList.add(currentAdvice);
                    bestDegree = currentDegree;
                    continue;
                }
                if (currentDegree != bestDegree) continue;
                bestAdviceList.add(currentAdvice);
            }
            if (bestAdviceList.size() == 1) {
                return (AdviceInfo)bestAdviceList.get(0);
            }
            greatestRank.clear();
            greatestRank.addAll(bestAdviceList);
            bestAdviceList.clear();
            bestDegree = Short.MAX_VALUE;
        }
        return null;
    }

    static interface MatchingRule {
        public boolean matches(AdviceMethodProperties var1);
    }

    static interface AdviceSignatureRule {
        public boolean applies(Method var1);

        public AdviceInfo getAdviceInfo(Method var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ReturnType {
        VOID,
        ANY,
        NOT_VOID;

    }
}

