/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.Version;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferGenerator_123;
import org.jboss.cache.statetransfer.StateTransferGenerator_124;
import org.jboss.cache.statetransfer.StateTransferGenerator_1241;
import org.jboss.cache.statetransfer.StateTransferGenerator_140;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jboss.cache.statetransfer.StateTransferIntegrator_123;
import org.jboss.cache.statetransfer.StateTransferIntegrator_124;
import org.jboss.cache.statetransfer.StateTransferIntegrator_1241;
import org.jboss.cache.statetransfer.StateTransferIntegrator_140;
import org.jboss.invocation.MarshalledValueInputStream;

public abstract class StateTransferFactory {
    private static final short RV_123 = Version.getVersionShort("1.2.3");
    private static final short RV_124 = Version.getVersionShort("1.2.4");
    private static final short RV_124SP1 = Version.getVersionShort("1.2.4.SP1");
    private static final short RV_140 = Version.getVersionShort("1.4.0");

    public static StateTransferGenerator getStateTransferGenerator(TreeCache cache) {
        short version = cache.getReplicationVersionShort();
        if (version == RV_124) {
            return new StateTransferGenerator_124(cache);
        }
        if (version == RV_124SP1) {
            return new StateTransferGenerator_1241(cache);
        }
        if (version <= RV_123 && version > 0) {
            return new StateTransferGenerator_123(cache);
        }
        if (version < RV_140 && version > 0) {
            return new StateTransferGenerator_1241(cache);
        }
        return new StateTransferGenerator_140(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateTransferIntegrator getStateTransferIntegrator(byte[] state, Fqn targetFqn, TreeCache cache) throws Exception {
        StateTransferIntegrator stateTransferIntegrator;
        MarshalledValueInputStream in;
        block30: {
            short version;
            block28: {
                block26: {
                    block24: {
                        ByteArrayInputStream bais = new ByteArrayInputStream(state);
                        bais.mark(1024);
                        version = 0;
                        in = null;
                        try {
                            in = new MarshalledValueInputStream((InputStream)bais);
                        }
                        catch (IOException e) {
                            version = RV_123;
                        }
                        try {
                            if (in != null) {
                                try {
                                    version = in.readShort();
                                }
                                catch (IOException io) {
                                    version = RV_123;
                                }
                            }
                            if (version != RV_124) break block24;
                            stateTransferIntegrator = new StateTransferIntegrator_124((ObjectInputStream)in, targetFqn, cache);
                            Object var8_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_14 = null;
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException io) {}
                            throw throwable;
                        }
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException io) {
                            // empty catch block
                        }
                        return stateTransferIntegrator;
                    }
                    if (version != RV_124SP1) break block26;
                    stateTransferIntegrator = new StateTransferIntegrator_1241(state, targetFqn, cache);
                    Object var8_10 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException io) {
                        // empty catch block
                    }
                    return stateTransferIntegrator;
                }
                if (version > RV_123 || version <= 0) break block28;
                stateTransferIntegrator = new StateTransferIntegrator_123(state, targetFqn, cache);
                Object var8_11 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException io) {
                    // empty catch block
                }
                return stateTransferIntegrator;
            }
            if (version >= RV_140 || version <= 0) break block30;
            stateTransferIntegrator = new StateTransferIntegrator_1241(state, targetFqn, cache);
            Object var8_12 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException io) {
                // empty catch block
            }
            return stateTransferIntegrator;
        }
        stateTransferIntegrator = new StateTransferIntegrator_140(state, targetFqn, cache);
        Object var8_13 = null;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException io) {
            // empty catch block
        }
        return stateTransferIntegrator;
    }
}

