/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.loader.JDBCCacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;

public class JDBCExtendedCacheLoader
extends JDBCCacheLoader
implements ExtendedCacheLoader {
    private RegionManager manager_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadState(Fqn subtree) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            this.setUnmarshallingClassLoader(subtree);
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream(1024);
            MarshalledValueOutputStream out = new MarshalledValueOutputStream((OutputStream)out_stream);
            this.loadState(subtree, (ObjectOutputStream)out);
            out.close();
            byte[] byArray = out_stream.toByteArray();
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            return byArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeState(byte[] state, Fqn subtree) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            this.setUnmarshallingClassLoader(subtree);
            ByteArrayInputStream in_stream = new ByteArrayInputStream(state);
            MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
            this.remove(subtree);
            boolean moveToBuddy = subtree.isChildOf(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN) && subtree.size() > 1;
            Fqn fqn = null;
            while (in_stream.available() > 0) {
                NodeData nd = (NodeData)in.readObject();
                fqn = moveToBuddy ? BuddyManager.getBackupFqn(subtree, nd.fqn) : nd.fqn;
                if (nd.attrs != null) {
                    this.put(fqn, nd.attrs, true);
                    continue;
                }
                this.put(fqn, null);
            }
            Object var10_9 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            throw throwable;
        }
    }

    public void setRegionManager(RegionManager manager) {
        this.manager_ = manager;
    }

    public byte[] loadEntireState() throws Exception {
        return this.loadState(Fqn.fromString("/"));
    }

    public void storeEntireState(byte[] state) throws Exception {
        this.storeState(state, Fqn.fromString("/"));
    }

    private void setUnmarshallingClassLoader(Fqn subtree) {
        if (this.manager_ != null) {
            this.manager_.setUnmarshallingClassLoader(subtree);
        }
    }
}

