/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.util.CloneableObject;
import org.jboss.util.NullArgumentException;
import org.jboss.util.PrettyString;
import org.jboss.util.state.State;

public class StateMachine
extends CloneableObject
implements Serializable {
    protected final Model model;
    protected final List changeListeners;

    public StateMachine(Model model) {
        if (model == null) {
            throw new NullArgumentException("model");
        }
        this.model = model;
        this.changeListeners = new ArrayList();
        State initialState = model.getInitialState();
        if (initialState == null) {
            throw new IllegalArgumentException("Model initial state is null");
        }
        this.reset();
    }

    private StateMachine(Model model, boolean hereForSigChangeOnly) {
        this.model = model;
        this.changeListeners = null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(super.toString()).append(" {").append("\n");
        buff.append("  Model:\n");
        this.model.appendPrettyString(buff, "    ").append("\n");
        buff.append("  Change listeners: ").append(this.changeListeners).append("\n}");
        return buff.toString();
    }

    public Model getModel() {
        return this.model;
    }

    public State getCurrentState() {
        return this.model.getCurrentState();
    }

    public State getInitialState() {
        return this.model.getInitialState();
    }

    public boolean isAcceptable(State state) {
        if (state == null) {
            throw new NullArgumentException("state");
        }
        if (!this.model.containsState(state) || this.isStateFinal()) {
            return false;
        }
        State currentState = this.model.getCurrentState();
        if (state.equals(currentState)) {
            return false;
        }
        boolean rv = false;
        state = this.model.getMappedState(state);
        if (currentState instanceof Acceptable) {
            rv = ((Acceptable)((Object)currentState)).isAcceptable(state);
        }
        Set states = this.model.acceptableStates(this.model.getCurrentState());
        if (!rv && states.contains(state)) {
            rv = true;
        }
        return rv;
    }

    public void transition(State state) {
        if (!this.isAcceptable(state)) {
            StringBuffer buff = new StringBuffer();
            State current = this.model.getCurrentState();
            if (this.isStateFinal()) {
                buff.append("Current state is final");
            } else {
                buff.append("State must be ");
                Set temp = this.model.acceptableStates(current);
                State[] states = temp.toArray(new State[temp.size()]);
                int i = 0;
                while (i < states.length) {
                    buff.append(states[i].getName());
                    if (i < states.length - 2) {
                        buff.append(", ");
                    } else if (i < states.length - 1) {
                        buff.append(" or ");
                    }
                    ++i;
                }
            }
            buff.append("; cannot accept state: ").append(state.getName()).append("; state=").append(current.getName());
            throw new IllegalStateException(buff.toString());
        }
        this.changeState(state);
    }

    public void reset() {
        State prev = this.model.getCurrentState();
        State initial = this.model.getInitialState();
        ChangeEvent event = this.changeState(initial);
        Iterator iter = this.model.states().iterator();
        while (iter.hasNext()) {
            State state = (State)iter.next();
            if (state.equals(prev) || state.equals(initial) || !(state instanceof ChangeListener)) continue;
            ((ChangeListener)((Object)state)).stateChanged(event);
        }
    }

    protected ChangeEvent changeState(State state) {
        state = this.model.getMappedState(state);
        State prev = this.model.getCurrentState();
        this.model.setCurrentState(state);
        ChangeEvent event = new ChangeEvent(this, prev, state);
        if (prev instanceof ChangeListener) {
            ((ChangeListener)((Object)prev)).stateChanged(event);
        }
        if (state instanceof ChangeListener) {
            ((ChangeListener)((Object)state)).stateChanged(event);
        }
        this.fireStateChanged(event);
        return event;
    }

    public Set finalStates() {
        HashSet<State> set = new HashSet<State>();
        Iterator iter = this.model.states().iterator();
        while (iter.hasNext()) {
            State state = (State)iter.next();
            if (!this.isStateFinal(state)) continue;
            set.add(state);
        }
        return Collections.unmodifiableSet(set);
    }

    public boolean isStateFinal(State state) {
        Set acceptable;
        if (state == null) {
            throw new NullArgumentException("state");
        }
        if (!this.model.containsState(state)) {
            throw new IllegalArgumentException("State not found in model: " + state);
        }
        if (state instanceof Acceptable) {
            Acceptable a = (Acceptable)((Object)state);
            Iterator iter = this.model.states().iterator();
            while (iter.hasNext()) {
                if (!a.isAcceptable((State)iter.next())) continue;
                return false;
            }
        }
        return (acceptable = this.model.acceptableStates(state)) == null;
    }

    public boolean isStateFinal() {
        return this.isStateFinal(this.model.getCurrentState());
    }

    public boolean isCurrentState(State state) {
        return this.model.getCurrentState().equals(state);
    }

    public boolean isInitialState(State state) {
        return this.model.getInitialState().equals(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            throw new NullArgumentException("listener");
        }
        List list = this.changeListeners;
        synchronized (list) {
            if (!this.changeListeners.contains(listener)) {
                this.changeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        List list = this.changeListeners;
        synchronized (list) {
            if (listener != null) {
                this.changeListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged(ChangeEvent event) {
        ChangeListener[] listeners;
        List list = this.changeListeners;
        synchronized (list) {
            listeners = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(event);
            ++i;
        }
    }

    public static StateMachine makeSynchronized(final StateMachine machine, final Object mutex) {
        if (machine == null) {
            throw new NullArgumentException("machine");
        }
        return new StateMachine(null, true){
            private Object lock;
            {
                this.lock = mutex == null ? this : mutex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Model getModel() {
                Object object = this.lock;
                synchronized (object) {
                    return machine.getModel();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public State getInitailState() {
                Object object = this.lock;
                synchronized (object) {
                    return machine.getInitialState();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public State getCurrentState() {
                Object object = this.lock;
                synchronized (object) {
                    return machine.getCurrentState();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isInitialState(State state) {
                Object object = this.lock;
                synchronized (object) {
                    return machine.isInitialState(state);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isCurrentState(State state) {
                Object object = this.lock;
                synchronized (object) {
                    return machine.isCurrentState(state);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isAcceptable(State state) {
                Object object = this.lock;
                synchronized (object) {
                    return machine.isAcceptable(state);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transition(State state) {
                Object object = this.lock;
                synchronized (object) {
                    machine.transition(state);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                Object object = this.lock;
                synchronized (object) {
                    machine.reset();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set finalStates() {
                Object object = this.lock;
                synchronized (object) {
                    return machine.finalStates();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isStateFinal(State state) {
                Object object = this.lock;
                synchronized (object) {
                    return machine.isStateFinal(state);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isStateFinal() {
                Object object = this.lock;
                synchronized (object) {
                    return machine.isStateFinal();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object clone() {
                Object object = this.lock;
                synchronized (object) {
                    return super.clone();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addChangeListener(ChangeListener listener) {
                Object object = this.lock;
                synchronized (object) {
                    machine.addChangeListener(listener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeChangeListener(ChangeListener listener) {
                Object object = this.lock;
                synchronized (object) {
                    machine.removeChangeListener(listener);
                }
            }
        };
    }

    public static StateMachine makeSynchronized(StateMachine machine) {
        return StateMachine.makeSynchronized(machine, null);
    }

    public static StateMachine makeImmutable(StateMachine machine, final boolean hideModel) {
        if (machine == null) {
            throw new NullArgumentException("machine");
        }
        return new StateMachine(machine.getModel(), true){

            public Model getModel() {
                if (hideModel) {
                    throw new UnsupportedOperationException("Model has been hidden; state machine is immutable");
                }
                return super.getModel();
            }

            public void transition(State state) {
                throw new UnsupportedOperationException("Can not transition; state machine is immutable");
            }

            public void reset() {
                throw new UnsupportedOperationException("Can not reset; state machine is immutable");
            }

            public void addChangeListener(ChangeListener listener) {
                throw new UnsupportedOperationException("Can not add change listener; state machine is immutable");
            }

            public void removeChangeListener(ChangeListener listener) {
                throw new UnsupportedOperationException("Can not remove change listener; state machine is immutable");
            }
        };
    }

    public static StateMachine makeImmutable(StateMachine machine) {
        return StateMachine.makeImmutable(machine, true);
    }

    public static interface Model
    extends CloneableObject.Cloneable,
    PrettyString.Appendable {
        public Set addState(State var1, Set var2);

        public Set addState(State var1, State[] var2);

        public Set addState(State var1);

        public State getMappedState(State var1);

        public boolean isMappedState(State var1);

        public void setInitialState(State var1);

        public State getInitialState();

        public void setCurrentState(State var1);

        public State getCurrentState();

        public boolean containsState(State var1);

        public Set removeState(State var1);

        public void clear();

        public Set states();

        public Set acceptableStates(State var1);
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }

    public static class ChangeEvent
    extends EventObject {
        public final State previous;
        public final State current;

        public ChangeEvent(StateMachine source, State previous, State current) {
            super(source);
            this.previous = previous;
            this.current = current;
        }

        public State getPreviousState() {
            return this.previous;
        }

        public State getCurrentState() {
            return this.current;
        }

        public StateMachine getStateMachine() {
            return (StateMachine)this.getSource();
        }

        public String toString() {
            return super.toString() + "{ previous=" + this.previous + ", current=" + this.current + " }";
        }
    }

    public static interface Acceptable {
        public boolean isAcceptable(State var1);
    }
}

