/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;

import org.jboss.metadata.annotation.creator.AbstractComponentProcessor;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;

/**
 * Comment
 *
 * @author <a href="mailto:carlo.dewolf@jboss.com">Carlo de Wolf</a>
 * @version $Revision: 67165 $
 */
public abstract class AbstractEnterpriseBeanProcessor<MD extends EnterpriseBeanMetaData>
   extends AbstractComponentProcessor<MD>
   implements Processor<EjbJar3xMetaData, Class<?>>
{
   protected abstract MD create(Class<?> beanClass);
   
   protected AbstractEnterpriseBeanProcessor(AnnotationFinder<AnnotatedElement> finder)
   {
      super(finder);
      addTypeProcessor(new TransactionAttributeClassProcessor<MD>(finder));
      addMethodProcessor(new TransactionAttributeMethodProcessor<MD>(finder));
   }

   public void process(EjbJar3xMetaData ejbJarMetaData, Class<?> beanClass)
   {
      MD beanMetaData = create(beanClass);
      if(beanMetaData == null)
         return;

      EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
      super.process(env, beanClass);
      beanMetaData.setJndiEnvironmentRefsGroup(env);
      
      if(ejbJarMetaData.getEnterpriseBeans() == null)
         ejbJarMetaData.setEnterpriseBeans(new EnterpriseBeansMetaData());
      
      ejbJarMetaData.getEnterpriseBeans().add(beanMetaData);
      
      processClass(beanMetaData, beanClass);
   }
   
}
