/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ejb.ApplicationExceptionProcessor;
import org.jboss.metadata.annotation.creator.ejb.StatefulProcessor;
import org.jboss.metadata.annotation.creator.ejb.StatelessProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;

/**
 * Create a Web25MetaData instance from the class annotations
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 67165 $
 */
public class Web25MetaDataCreator extends AbstractFinderUser
   implements Creator<Collection<Class>, Web25MetaData>
{
   private List<Processor<WebMetaData, Class<?>>> processors;
   
   public Web25MetaDataCreator(AnnotationFinder<AnnotatedElement> finder)
   {
      super(finder);
      
      processors = new ArrayList<Processor<WebMetaData,Class<?>>>();
      processors.add(new WebComponentProcessor(finder));
   }

   public Web25MetaData create(Collection<Class> classes)
   {
      Web25MetaData metaData = new Web25MetaData();
      metaData.setVersion("2.5");

      for(Class<?> cls : classes)
      {
         for(Processor<WebMetaData, Class<?>> processor : processors)
         {
            processor.process(metaData, cls);
         }
      }
      
      return metaData;
   }

}
