/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.web.jboss;

import org.jboss.metadata.javaee.support.IdMetaDataImpl;

/**
 * Represents a <passivation-config> element of the jboss-web.xml 
 * deployment descriptor 
 * 
 * @author Brian Stansberry
 * @version <tt>$Revision: 67086 $</tt>
 */
public class PassivationConfig extends IdMetaDataImpl
{  
   /** The serialVersionUID */
   private static final long serialVersionUID = 1;

   /**
    * If true then the session passivation is enabled for this web app.
    * If false then the session passivation is disabled for this web app. 
    */
   private Boolean useSessionPassivation;
   
   /**
    * Min time (seconds) the session must be idle since lastAccesstime before it's eligable for passivation
    * This overrides maxActive_, to prevent thrashing if the there are lots of active sessions.
    * Setting to -1 means it's ignored
    */
   private Integer passivationMinIdleTime;
   
   /**
    * Max time (seconds) the session must be idle since lastAccesstime before it's eligable for passivation
    * This overrides maxActive_, to prevent thrashing if the there are lots of active sessions.
    * Setting to -1 means session should not be forced out.
    */
   private Integer passivationMaxIdleTime;

   public Integer getPassivationMaxIdleTime()
   {
      return passivationMaxIdleTime;
   }

   public void setPassivationMaxIdleTime(Integer passivationMaxIdleTime)
   {
      this.passivationMaxIdleTime = passivationMaxIdleTime;
   }

   public Integer getPassivationMinIdleTime()
   {
      return passivationMinIdleTime;
   }

   public void setPassivationMinIdleTime(Integer passivationMinIdleTime)
   {
      this.passivationMinIdleTime = passivationMinIdleTime;
   }

   public Boolean getUseSessionPassivation()
   {
      return useSessionPassivation;
   }

   public void setUseSessionPassivation(Boolean useSessionPassivation)
   {
      this.useSessionPassivation = useSessionPassivation;
   }
   
}
