/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.reflect.AnnotatedElement;
import javax.ejb.ApplicationException;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationExceptionProcessor
extends AbstractFinderUser
implements Creator<Class<?>, ApplicationExceptionMetaData>,
Processor<EjbJar3xMetaData, Class<?>> {
    protected ApplicationExceptionProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public ApplicationExceptionMetaData create(Class<?> element) {
        ApplicationException annotation = this.finder.getAnnotation(element, ApplicationException.class);
        if (annotation == null) {
            return null;
        }
        if (!Exception.class.isAssignableFrom(element)) {
            throw new IllegalArgumentException("ApplicationException is only valid on an Exception");
        }
        ApplicationExceptionMetaData metaData = new ApplicationExceptionMetaData();
        metaData.setExceptionClass(element.getName());
        metaData.setRollback(annotation.rollback());
        return metaData;
    }

    @Override
    public void process(EjbJar3xMetaData ejbJar, Class<?> type) {
        ApplicationExceptionMetaData applicationException = this.create(type);
        if (applicationException == null) {
            return;
        }
        if (ejbJar.getAssemblyDescriptor() == null) {
            ejbJar.setAssemblyDescriptor(new AssemblyDescriptorMetaData());
        }
        if (ejbJar.getAssemblyDescriptor().getApplicationExceptions() == null) {
            ejbJar.getAssemblyDescriptor().setApplicationExceptions(new ApplicationExceptionsMetaData());
        }
        ejbJar.getAssemblyDescriptor().getApplicationExceptions().add(applicationException);
    }
}

