/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.ejb.Init;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.MethodParametersHelper;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.InitMethodMetaData;
import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitProcessor
extends AbstractFinderUser
implements Creator<Method, InitMethodMetaData>,
Processor<SessionBeanMetaData, Method> {
    public InitProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public InitMethodMetaData create(Method method) {
        String alternativeName;
        Init init = this.finder.getAnnotation(method, Init.class);
        if (init == null) {
            return null;
        }
        InitMethodMetaData metaData = new InitMethodMetaData();
        NamedMethodMetaData beanMethod = new NamedMethodMetaData();
        metaData.setBeanMethod(beanMethod);
        NamedMethodMetaData createMethod = new NamedMethodMetaData();
        metaData.setCreateMethod(createMethod);
        String string = alternativeName = init.value().length() > 0 ? init.value() : method.getName();
        if (method.getDeclaringClass().isInterface()) {
            beanMethod.setMethodName(alternativeName);
            createMethod.setMethodName(method.getName());
        } else {
            beanMethod.setMethodName(method.getName());
            createMethod.setMethodName(alternativeName);
        }
        MethodParametersMetaData methodParams = MethodParametersHelper.create(method);
        beanMethod.setMethodParams(methodParams);
        createMethod.setMethodParams(methodParams);
        return metaData;
    }

    @Override
    public void process(SessionBeanMetaData bean, Method method) {
        InitMethodMetaData initMethod = this.create(method);
        if (initMethod == null) {
            return;
        }
        if (bean.getSessionType() != SessionType.Stateful) {
            throw new IllegalArgumentException("Init annotation is only valid on a stateful bean");
        }
        if (bean.getInitMethods() == null) {
            bean.setInitMethods(new InitMethodsMetaData());
        }
        bean.getInitMethods().add(initMethod);
    }
}

