/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.ejb.TransactionAttribute;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.MethodParametersHelper;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.metadata.ejb.spec.TransAttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactionAttributeProcessor<E extends AnnotatedElement, T extends EnterpriseBeanMetaData>
extends AbstractFinderUser {
    protected AbstractTransactionAttributeProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    protected abstract ContainerTransactionMetaData createContainerTransaction(String var1, TransactionAttribute var2, E var3);

    private MethodMetaData createMethod(String ejbName, Method method) {
        MethodMetaData methodMetaData = new MethodMetaData();
        methodMetaData.setEjbName(ejbName);
        if (method == null) {
            methodMetaData.setMethodName("*");
        } else {
            methodMetaData.setMethodName(method.getName());
            MethodParametersMetaData methodParameters = MethodParametersHelper.create(method);
            if (methodParameters != null) {
                methodMetaData.setMethodParams(methodParameters);
            }
        }
        return methodMetaData;
    }

    protected MethodsMetaData createMethods(String ejbName, Method method) {
        MethodsMetaData methods = new MethodsMetaData();
        methods.add(this.createMethod(ejbName, method));
        return methods;
    }

    protected TransAttributeType createTransAttributeType(TransactionAttribute annotation) {
        switch (annotation.value()) {
            case MANDATORY: {
                return TransAttributeType.Mandatory;
            }
            case NEVER: {
                return TransAttributeType.Never;
            }
            case NOT_SUPPORTED: {
                return TransAttributeType.NotSupported;
            }
            case REQUIRED: {
                return TransAttributeType.Required;
            }
            case REQUIRES_NEW: {
                return TransAttributeType.RequiresNew;
            }
            case SUPPORTS: {
                return TransAttributeType.Supports;
            }
        }
        throw new IllegalArgumentException("Unknown transaction attribute value " + annotation.value());
    }

    public void process(T bean, E element) {
        TransactionAttribute annotation = this.finder.getAnnotation(element, TransactionAttribute.class);
        if (annotation == null) {
            return;
        }
        EjbJarMetaData ejbJarMetaData = ((EnterpriseBeanMetaData)bean).getEjbJarMetaData();
        if (ejbJarMetaData.getAssemblyDescriptor() == null) {
            ejbJarMetaData.setAssemblyDescriptor(new AssemblyDescriptorMetaData());
        }
        if (ejbJarMetaData.getAssemblyDescriptor().getContainerTransactions() == null) {
            ejbJarMetaData.getAssemblyDescriptor().setContainerTransactions(new ContainerTransactionsMetaData());
        }
        ContainerTransactionMetaData transaction = this.createContainerTransaction(((EnterpriseBeanMetaData)bean).getEjbName(), annotation, element);
        ejbJarMetaData.getAssemblyDescriptor().getContainerTransactions().add(transaction);
    }
}

