/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import javax.ejb.Local;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalProcessor
extends AbstractFinderUser
implements Processor<SessionBeanMetaData, Class<?>> {
    public LocalProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(SessionBeanMetaData metaData, Class<?> type) {
        Local local = this.finder.getAnnotation(type, Local.class);
        if (local == null) {
            return;
        }
        if (type.isInterface()) {
            if (metaData.getLocalHome() != null) {
                if (metaData.getLocal() != null) {
                    throw new IllegalArgumentException("2.1 bean " + metaData.getEjbName() + " already has a local interface " + metaData.getLocal() + ", can't add " + type.getName());
                }
                metaData.setLocal(type.getName());
            } else {
                if (metaData.getBusinessLocals() == null) {
                    metaData.setBusinessLocals(new BusinessLocalsMetaData());
                }
                metaData.getBusinessLocals().add(type.getName());
            }
        } else {
            if (local.value() == null || local.value().length == 0) {
                throw new IllegalArgumentException("Empty @Local on bean class " + type.getName() + " is not allowed");
            }
            if (metaData.getLocalHome() != null) {
                if (metaData.getLocal() != null) {
                    throw new IllegalArgumentException("2.1 bean " + metaData.getEjbName() + " already has a local interface " + metaData.getLocal() + ", can't add " + type.getName());
                }
                if (local.value().length > 1) {
                    throw new IllegalArgumentException("2.1 bean " + type.getName() + " has more than one local interface defined");
                }
                metaData.setLocal(local.value()[0].getName());
            } else {
                if (metaData.getBusinessLocals() == null) {
                    metaData.setBusinessLocals(new BusinessLocalsMetaData());
                }
                for (Class businessInterface : local.value()) {
                    metaData.getBusinessLocals().add(businessInterface.getName());
                }
            }
        }
    }
}

