/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import javax.ejb.Remote;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProcessor
extends AbstractFinderUser
implements Processor<SessionBeanMetaData, Class<?>> {
    public RemoteProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(SessionBeanMetaData metaData, Class<?> type) {
        Remote remote = this.finder.getAnnotation(type, Remote.class);
        if (remote == null) {
            return;
        }
        if (type.isInterface()) {
            if (metaData.getHome() != null) {
                if (metaData.getRemote() != null) {
                    throw new IllegalArgumentException("2.1 bean " + metaData.getEjbName() + " already has a remote interface " + metaData.getRemote() + ", can't add " + type.getName());
                }
                metaData.setRemote(type.getName());
            } else {
                if (metaData.getBusinessRemotes() == null) {
                    metaData.setBusinessRemotes(new BusinessRemotesMetaData());
                }
                metaData.getBusinessRemotes().add(type.getName());
            }
        } else {
            if (remote.value() == null || remote.value().length == 0) {
                throw new IllegalArgumentException("Empty @Remote on bean class " + type.getName() + " is not allowed");
            }
            if (metaData.getHome() != null) {
                if (metaData.getRemote() != null) {
                    throw new IllegalArgumentException("2.1 bean " + metaData.getEjbName() + " already has a remote interface " + metaData.getRemote() + ", can't add " + type.getName());
                }
                if (remote.value().length > 1) {
                    throw new IllegalArgumentException("2.1 bean " + type.getName() + " has more than one remote interface defined");
                }
                metaData.setRemote(remote.value()[0].getName());
            } else {
                if (metaData.getBusinessRemotes() == null) {
                    metaData.setBusinessRemotes(new BusinessRemotesMetaData());
                }
                for (Class businessInterface : remote.value()) {
                    metaData.getBusinessRemotes().add(businessInterface.getName());
                }
            }
        }
    }
}

