/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenDestinationMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SubscriptionDurability;
import org.jboss.metadata.ejb.spec.TransactionType;

@XmlType(name="message-driven-beanType")
public class MessageDrivenBeanMetaData
extends EnterpriseBeanMetaData {
    private static final long serialVersionUID = -7353017099819838715L;
    private String messagingType;
    private NamedMethodMetaData timeoutMethod;
    private TransactionType transactionType;
    private String messageDestinationType;
    private String messageDestinationLink;
    private ActivationConfigMetaData activationConfig;
    private AroundInvokesMetaData aroundInvokes;
    private String messageSelector;
    private String acknowledgeMode;
    private SubscriptionDurability subscriptionDurability = SubscriptionDurability.NonDurable;

    public boolean isMessageDriven() {
        return true;
    }

    public String getMessagingType() {
        return this.messagingType;
    }

    public boolean isJMS() {
        String messagingType = this.getMessagingType();
        return messagingType == null || "javax.jms.MessageListener".equals(messagingType);
    }

    public void setMessagingType(String messagingType) {
        if (messagingType == null) {
            throw new IllegalArgumentException("Null messagingType");
        }
        this.messagingType = messagingType;
    }

    public NamedMethodMetaData getTimeoutMethod() {
        return this.timeoutMethod;
    }

    @XmlElement(required=false)
    public void setTimeoutMethod(NamedMethodMetaData timeoutMethod) {
        if (timeoutMethod == null) {
            throw new IllegalArgumentException("Null timeoutMethod");
        }
        this.timeoutMethod = timeoutMethod;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        if (transactionType == null) {
            throw new IllegalArgumentException("Null transactionType");
        }
        this.transactionType = transactionType;
    }

    public String getMessageDestinationType() {
        return this.messageDestinationType;
    }

    public void setMessageDestinationType(String messageDestinationType) {
        if (messageDestinationType == null) {
            throw new IllegalArgumentException("Null messageDestinationType");
        }
        this.messageDestinationType = messageDestinationType;
    }

    public AroundInvokesMetaData getAroundInvokes() {
        return this.aroundInvokes;
    }

    @XmlElement(name="around-invoke", required=false)
    public void setAroundInvokes(AroundInvokesMetaData aroundInvokes) {
        if (aroundInvokes == null) {
            throw new IllegalArgumentException("Null aroundInvokes");
        }
        this.aroundInvokes = aroundInvokes;
    }

    public String getMessageDestinationLink() {
        return this.messageDestinationLink;
    }

    public void setMessageDestinationLink(String messageDestinationLink) {
        if (messageDestinationLink == null) {
            throw new IllegalArgumentException("Null messageDestinationLink");
        }
        this.messageDestinationLink = messageDestinationLink;
    }

    public ActivationConfigMetaData getActivationConfig() {
        return this.activationConfig;
    }

    public void setActivationConfig(ActivationConfigMetaData activationConfig) {
        if (activationConfig == null) {
            throw new IllegalArgumentException("Null activationConfig");
        }
        this.activationConfig = activationConfig;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    @XmlElement(required=false)
    public void setMessageSelector(String messageSelector) {
        if (messageSelector == null) {
            throw new IllegalArgumentException("Null messageSelector");
        }
        this.messageSelector = messageSelector;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    @XmlElement(required=false)
    public void setAcknowledgeMode(String acknowledgeMode) {
        if (acknowledgeMode == null) {
            throw new IllegalArgumentException("Null acknowledgeMode");
        }
        this.acknowledgeMode = acknowledgeMode;
    }

    public SubscriptionDurability getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    @XmlElement(required=false)
    public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability) {
        if (subscriptionDurability == null) {
            throw new IllegalArgumentException("Null subscriptionDurability");
        }
        this.subscriptionDurability = subscriptionDurability;
    }

    @XmlElement(name="message-driven-destination", required=false)
    public void setMessageDrivenDestination(MessageDrivenDestinationMetaData mdd) {
        this.setMessageDestinationType(mdd.getDestinationType());
        String durability = mdd.getSubscriptionDurability();
        SubscriptionDurability sd = SubscriptionDurability.NonDurable;
        if (durability != null && durability.equalsIgnoreCase("Durable")) {
            sd = SubscriptionDurability.Durable;
        }
        this.setSubscriptionDurability(sd);
    }
}

