/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.Invoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.marshal.MarshallLoaderFactory;

public abstract class AbstractInvoker
implements Invoker {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected ClassByteClassLoader classbyteloader;
    protected InvokerLocator locator;
    protected Map localServerLocators = new HashMap();
    protected String serializationType;
    protected Map configuration = new HashMap();

    public AbstractInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public AbstractInvoker(InvokerLocator locator, Map configuration) {
        this.classbyteloader = new ClassByteClassLoader(this.getClass().getClassLoader());
        this.locator = locator;
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
        if (locator.getParameters() != null) {
            this.configuration.putAll(locator.getParameters());
        }
        try {
            InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
            if (loaderLocator != null) {
                this.classbyteloader.setClientInvoker(new Client(loaderLocator));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not create remote class loading for invoker.", (Throwable)e);
        }
        if (locator == null || locator.getParameters() == null) {
            this.setSerializationType("java");
        } else {
            this.setSerializationType(locator.findSerializationType());
        }
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void addClientLocator(String listenerId, InvokerLocator locator) {
        InvokerLocator obj = this.localServerLocators.put(listenerId, locator);
        if (obj != null) {
            throw new RuntimeException("InvokerLocator already exists for listener id " + listenerId + ".  " + "Remove this listener before adding again.");
        }
    }

    public InvokerLocator getClientLocator(String listenerId) {
        return (InvokerLocator)this.localServerLocators.get(listenerId);
    }

    public synchronized void setClassLoader(ClassLoader classloader) {
        this.classbyteloader = new ClassByteClassLoader(classloader);
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classbyteloader;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }
}

