/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.ConnectionValidator;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.LeasePinger;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.stream.StreamServer;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.util.id.GUID;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;

public class Client {
    public static final String LISTENER_ID_KEY = "listenerId";
    public static final int MAX_NUM_ONEWAY_THREADS = 10;
    public static final String RAW = "RAW_PAYLOAD";
    private int maxNumberThreads = 10;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$Client == null ? (class$org$jboss$remoting$Client = Client.class$("org.jboss.remoting.Client")) : class$org$jboss$remoting$Client));
    private ClientInvoker invoker;
    private ClassLoader classloader;
    private String subsystem;
    private String sessionId = new GUID().toString();
    private ThreadPool onewayThreadPool;
    private ConnectionValidator connectionValidator = null;
    private LeasePinger leasePinger = null;
    private Map configuration = null;
    static /* synthetic */ Class class$org$jboss$remoting$Client;

    public Client(InvokerLocator locator) throws Exception {
        this(locator, null, null);
    }

    public Client(InvokerLocator locator, Map configuration) throws Exception {
        this(locator, null, configuration);
    }

    public Client(InvokerLocator locator, String subsystem) throws Exception {
        this(locator, subsystem, null);
    }

    public Client(InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this(Thread.currentThread().getContextClassLoader(), locator, subsystem, configuration);
    }

    public Client(ClassLoader cl, InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this(cl, InvokerRegistry.createClientInvoker(locator, configuration), subsystem);
        this.configuration = configuration;
    }

    public Client(ClassLoader cl, ClientInvoker invoker, String subsystem) throws Exception {
        this.classloader = cl;
        this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        this.invoker = invoker;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (this.connectionValidator == null) {
            this.connectionValidator = new ConnectionValidator(this);
        }
        this.connectionValidator.addConnectionListener(listener);
    }

    public void addConnectionListener(ConnectionListener listener, int pingPeriod) {
        if (this.connectionValidator == null) {
            this.connectionValidator = new ConnectionValidator(this, pingPeriod);
        }
        this.connectionValidator.addConnectionListener(listener);
    }

    public boolean removeConnectionListener(ConnectionListener listener) {
        return this.connectionValidator.removeConnectionListener(listener);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConnected() {
        return this.invoker != null && this.invoker.isConnected();
    }

    public void connect() throws Exception {
        if (!this.isConnected()) {
            this.connect(this.invoker);
        }
    }

    private void connect(ClientInvoker invoker) {
        invoker.connect();
        this.setupClientLease(invoker);
    }

    private void setupClientLease(ClientInvoker invoker) {
        Object ret = null;
        try {
            Long leaseTimeoutValue;
            long leaseTimeout;
            InvocationResponse resp;
            Map respMap;
            ret = invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, "$PING$", this.configuration, null, null));
            if (ret instanceof InvocationResponse && (respMap = (resp = (InvocationResponse)ret).getPayload()) != null && (leaseTimeout = (leaseTimeoutValue = (Long)respMap.get("clientLeasePeriod")).longValue()) > 0L) {
                if (this.leasePinger == null) {
                    this.leasePinger = new LeasePinger(this);
                }
                this.leasePinger.startPing(leaseTimeout);
            }
        }
        catch (Throwable throwable) {
            log.error((Object)"Error setting up client lease.", throwable);
        }
    }

    public void disconnect() {
        if (this.leasePinger != null) {
            try {
                this.invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, "$DISCONNECT$", null, null, null));
            }
            catch (Throwable throwable) {
                log.error((Object)"Error sending disconnect to server to end client lease.", throwable);
            }
            this.leasePinger.stopPing();
        }
        this.invoker.disconnect();
    }

    public ClientInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ClientInvoker invoker) {
        this.invoker = invoker;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public Object invoke(Object param) throws Throwable {
        return this.invoke(param, null);
    }

    public Object invoke(Object param, Map metadata) throws Throwable {
        return this.invoke(param, metadata, null);
    }

    private Object invoke(Object param, Map metadata, InvokerLocator callbackServerLocator) throws Throwable {
        ClientInvoker localInvoker = this.invoker;
        if (localInvoker != null) {
            if (!localInvoker.isConnected()) {
                log.debug((Object)("invoke called, but our invoker is disconnected, discarding and fetching another fresh invoker for: " + this.invoker.getLocator()));
                localInvoker = InvokerRegistry.createClientInvoker(localInvoker.getLocator());
                this.connect(localInvoker);
            }
        } else {
            throw new Exception("Can not perform invoke because invoker is null.");
        }
        Object ret = localInvoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, param, metadata, null, callbackServerLocator));
        this.invoker = localInvoker;
        return ret;
    }

    public void invokeOneway(final Object param, final Map sendPayload, boolean clientSide) throws Throwable {
        if (clientSide) {
            ThreadPool threadPool = this.getOnewayThreadPool();
            Runnable onewayRun = new Runnable(){

                public void run() {
                    try {
                        Client.this.invoke(param, sendPayload);
                    }
                    catch (Throwable e) {
                        log.error((Object)("Error executing client oneway invocation request: " + param), e);
                    }
                }
            };
            threadPool.run(onewayRun);
        } else {
            OnewayInvocation invocation = new OnewayInvocation(param);
            this.invoke(invocation, sendPayload);
        }
    }

    public void setMaxNumberOfThreads(int numOfThreads) {
        this.maxNumberThreads = numOfThreads;
    }

    public int getMaxNumberOfThreads() {
        return this.maxNumberThreads;
    }

    public ThreadPool getOnewayThreadPool() {
        if (this.onewayThreadPool == null) {
            BasicThreadPool pool = new BasicThreadPool("JBossRemoting Client Oneway");
            pool.setMaximumPoolSize(this.maxNumberThreads);
            pool.setBlockingMode(BlockingMode.WAIT);
            this.onewayThreadPool = pool;
        }
        return this.onewayThreadPool;
    }

    public void setOnewayThreadPool(ThreadPool pool) {
        this.onewayThreadPool = pool;
    }

    public void invokeOneway(Object param) throws Throwable {
        this.invokeOneway(param, null);
    }

    public void invokeOneway(Object param, Map sendPayload) throws Throwable {
        this.invokeOneway(param, sendPayload, false);
    }

    public void addListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        this.addListener(callbackHandler, null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator) throws Throwable {
        this.addListener(callbackHandler, clientLocator, null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator, Object callbackHandlerObject) throws Throwable {
        Map metadata;
        if (callbackHandler != null) {
            metadata = this.createListenerMetadata(callbackHandler);
            String listenerId = (String)metadata.get(LISTENER_ID_KEY);
            this.invoker.addClientLocator(listenerId, clientLocator);
            if (clientLocator != null) {
                Client client = new Client(clientLocator, this.subsystem);
                client.setSessionId(this.getSessionId());
                client.connect();
                client.invoke(new InternalInvocation("addClientListener", new Object[]{callbackHandler, callbackHandlerObject}), metadata);
                client.disconnect();
            }
        } else {
            throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
        }
        this.invoke(new InternalInvocation("addListener", null), metadata, clientLocator);
    }

    private Map createListenerMetadata(InvokerCallbackHandler callbackHandler) {
        String listenerId = String.valueOf(callbackHandler.hashCode());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(LISTENER_ID_KEY, listenerId);
        return metadata;
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        Map metadata;
        if (callbackHandler != null) {
            metadata = this.createListenerMetadata(callbackHandler);
            String listenerId = (String)metadata.get(LISTENER_ID_KEY);
            InvokerLocator locator = this.invoker.getClientLocator(listenerId);
            if (locator != null) {
                Client client = new Client(locator, this.subsystem);
                client.setSessionId(this.getSessionId());
                client.connect();
                client.invoke(new InternalInvocation("removeClientListener", new Object[]{callbackHandler}), metadata);
                client.disconnect();
            }
        } else {
            throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
        }
        this.invoke(new InternalInvocation("removeListener", null), metadata);
    }

    public List getCallbacks(InvokerCallbackHandler callbackHandler) throws Throwable {
        if (callbackHandler != null) {
            Map metadata = this.createListenerMetadata(callbackHandler);
            return (List)this.invoke(new InternalInvocation("getCallbacks", null), metadata);
        }
        throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
    }

    public void setMarshaller(Marshaller marshaller) {
        if (this.invoker != null && marshaller != null) {
            this.invoker.setMarshaller(marshaller);
        }
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        if (this.invoker != null && unmarshaller != null) {
            this.invoker.setUnMarshaller(unmarshaller);
        }
    }

    public Object invoke(InputStream inputStream, Object param) throws Throwable {
        StreamServer streamServer = new StreamServer(inputStream);
        String locator = streamServer.getInvokerLocator();
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, param}), null);
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

