/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.remoting.ConnectionNotifier;

public class Lease {
    public static long TIMER_DELAY = 5000L;
    private ConnectionNotifier notifier = null;
    private String clientSessionId = null;
    private long leasePeriod = -1L;
    private String locatorURL = null;
    private Map requestPayload = null;
    private Timer leaseTimer = null;
    private boolean leaseUpdated = false;

    public Lease(String clientSessionId, long leasePeriod, String locatorurl, Map requestPayload, ConnectionNotifier notifier) {
        this.clientSessionId = clientSessionId;
        this.leasePeriod = leasePeriod;
        this.notifier = notifier;
        this.locatorURL = locatorurl;
        this.requestPayload = requestPayload;
        this.leaseTimer = new Timer(true);
    }

    public void startLease() {
        this.leaseTimer.schedule((TimerTask)new LeaseTimerTask(), this.leasePeriod + TIMER_DELAY, this.leasePeriod);
    }

    public void updateLease(long leasePeriod) {
        this.leaseUpdated = true;
        if (leasePeriod != this.leasePeriod) {
            this.leasePeriod = leasePeriod;
            this.leaseTimer.cancel();
            this.leaseTimer.schedule((TimerTask)new LeaseTimerTask(), leasePeriod + TIMER_DELAY, leasePeriod);
        }
    }

    public void terminateLease(long leasePeriod) {
        this.stopLease();
        this.notifier.connectionTerminated(this.locatorURL, this.clientSessionId, this.requestPayload);
    }

    private void stopLease() {
        this.leaseTimer.cancel();
    }

    private class LeaseTimerTask
    extends TimerTask {
        private LeaseTimerTask() {
        }

        public void run() {
            if (Lease.this.leaseUpdated) {
                Lease.this.leaseUpdated = false;
            } else {
                Lease.this.notifier.connectionLost(Lease.this.locatorURL, Lease.this.clientSessionId, Lease.this.requestPayload);
                Lease.this.stopLease();
            }
        }
    }
}

