/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.ConnectionNotifier;
import org.jboss.remoting.InvalidConfigurationException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.Lease;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvokerMBean;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.stream.StreamHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolMBean;

public abstract class ServerInvoker
extends AbstractInvoker
implements ServerInvokerMBean {
    public static final String MAX_NUM_ONEWAY_THREADS_KEY = "maxNumThreadsOneway";
    public static final String ONEWAY_THREAD_POOL_CLASS_KEY = "onewayThreadPool";
    public static final String SERVER_BIND_ADDRESS_KEY = "serverBindAddress";
    public static final String CLIENT_CONNECT_ADDRESS_KEY = "clientConnectAddress";
    public static final String SERVER_BIND_PORT_KEY = "serverBindPort";
    public static final String CLIENT_CONNECT_PORT_KEY = "clientConnectPort";
    public static final String CLIENT_LEASE_PERIOD = "clientLeasePeriod";
    public static final int MAX_NUM_ONEWAY_THREADS = 100;
    private int maxNumberThreads = 100;
    private String onewayThreadPoolClass = null;
    private ThreadPool onewayThreadPool;
    protected Map handlers = new HashMap();
    protected Map callbackHandlers = new HashMap();
    protected Map clientCallbackListener = new HashMap();
    private boolean started = false;
    private boolean created = false;
    private MBeanServer mbeanServer = null;
    private String dataType;
    private String serverBindAddress = null;
    private int serverBindPort = 0;
    private String clientConnectAddress = null;
    private int clientConnectPort = -1;
    private long leasePeriod = -1L;
    private boolean leaseManagement = false;
    private Map clientLeases = new HashMap();
    private ConnectionNotifier connectionNotifier = null;
    static /* synthetic */ Class class$org$jboss$util$threadpool$ThreadPoolMBean;

    public ServerInvoker(InvokerLocator locator) {
        super(locator);
        Map params = locator.getParameters();
        if (this.configuration != null && params != null) {
            this.configuration.putAll(locator.getParameters());
        }
    }

    public ServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator);
        Map locatorParams;
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
        if ((locatorParams = locator.getParameters()) != null) {
            this.configuration.putAll(locator.getParameters());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void setup() throws Exception {
        config = this.getConfiguration();
        maxNumOfThreads = (String)config.get("maxNumThreadsOneway");
        if (maxNumOfThreads != null && maxNumOfThreads.length() > 0) {
            try {
                this.maxNumberThreads = Integer.parseInt(maxNumOfThreads);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Can not convert max number of threads value (" + maxNumOfThreads + ") into a number."));
            }
        }
        this.onewayThreadPoolClass = (String)config.get("onewayThreadPool");
        locatorHost = this.locator.getHost();
        addr = null;
        addr = locatorHost != null ? InetAddress.getByName(this.locator.getHost()) : InetAddress.getLocalHost();
        port = this.locator.getPort();
        if (port <= 0) {
            port = PortUtil.findFreePort(this.locator.getHost());
            newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), port, this.locator.getPath(), this.locator.getParameters());
            InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
            this.locator = newLocator;
        }
        this.serverBindAddress = (String)config.get("serverBindAddress");
        this.clientConnectAddress = (String)config.get("clientConnectAddress");
        if (this.serverBindAddress == null) {
            this.serverBindAddress = this.clientConnectAddress != null ? InetAddress.getLocalHost().getHostAddress() : addr.getHostAddress();
        }
        serverBindPortString = (String)config.get("serverBindPort");
        clientConnectPortString = (String)config.get("clientConnectPort");
        if (clientConnectPortString != null) {
            try {
                this.clientConnectPort = Integer.parseInt(clientConnectPortString);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Can not set client bind port because can not convert given value (" + clientConnectPortString + ") to a number.");
            }
        }
        if (serverBindPortString != null) {
            try {
                this.serverBindPort = Integer.parseInt(serverBindPortString);
                if (this.serverBindPort > 0) ** GOTO lbl43
                this.serverBindPort = PortUtil.findFreePort(this.locator.getHost());
                newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), this.serverBindPort, this.locator.getPath(), this.locator.getParameters());
                InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
                this.locator = newLocator;
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Can not set server bind port because can not convert given value (" + serverBindPortString + ") to a number.");
            }
        } else {
            this.serverBindPort = this.clientConnectPort > 0 ? PortUtil.findFreePort(this.locator.getHost()) : port;
        }
lbl43:
        // 3 sources

        clientLeasePeriod = (String)config.get("clientLeasePeriod");
        if (clientLeasePeriod != null) {
            try {
                leasePeriodValue = Long.parseLong(clientLeasePeriod);
                this.setLeasePeriod(leasePeriodValue);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Can not set client lease period because can not convert given value (" + clientLeasePeriod + ") to a number.");
            }
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (this.connectionNotifier == null) {
            this.connectionNotifier = new ConnectionNotifier();
        }
        this.connectionNotifier.addListener(listener);
        if (this.leasePeriod > 0L) {
            this.leaseManagement = true;
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        if (this.connectionNotifier != null) {
            this.connectionNotifier.removeListener(listener);
        }
    }

    public void setLeasePeriod(long leasePeriodValue) {
        if (leasePeriodValue > 0L) {
            this.leasePeriod = leasePeriodValue;
            if (this.connectionNotifier != null && this.connectionNotifier.size() > 0) {
                this.leaseManagement = true;
            }
        }
    }

    public long getLeasePeriod() {
        return this.leasePeriod;
    }

    public String getClientConnectAddress() {
        return this.clientConnectAddress;
    }

    public int getClientConnectPort() {
        return this.clientConnectPort;
    }

    public void setClientConnectPort(int clientConnectPort) {
        this.clientConnectPort = clientConnectPort;
    }

    public void setClientConnectAddress(String clientConnectAddress) {
        this.clientConnectAddress = clientConnectAddress;
    }

    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setMaxNumberOfOnewayThreads(int numOfThreads) {
        this.maxNumberThreads = numOfThreads;
    }

    public int getMaxNumberOfOnewayThreads() {
        return this.maxNumberThreads;
    }

    public ThreadPool getOnewayThreadPool() {
        if (this.onewayThreadPool == null) {
            if (this.onewayThreadPoolClass == null || this.onewayThreadPoolClass.length() == 0) {
                BasicThreadPool pool = new BasicThreadPool("JBossRemoting Client Oneway");
                pool.setMaximumPoolSize(this.maxNumberThreads);
                pool.setBlockingMode(BlockingMode.WAIT);
                this.onewayThreadPool = pool;
            } else {
                boolean isObjName = false;
                try {
                    ObjectName objName = new ObjectName(this.onewayThreadPoolClass);
                    this.onewayThreadPool = this.createThreadPoolProxy(objName);
                    isObjName = true;
                }
                catch (MalformedObjectNameException e) {
                    this.log.debug((Object)"Thread pool class supplied is not an object name.");
                }
                if (!isObjName) {
                    try {
                        this.onewayThreadPool = (ThreadPool)this.getClassLoader().loadClass(this.onewayThreadPoolClass).newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error loading instance of ThreadPool based on class name: " + this.onewayThreadPoolClass);
                    }
                }
            }
        }
        return this.onewayThreadPool;
    }

    public void setOnewayThreadPool(ThreadPool pool) {
        this.onewayThreadPool = pool;
    }

    private ThreadPool createThreadPoolProxy(ObjectName objName) {
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            throw new RuntimeException("Can not register MBean ThreadPool as the ServerInvoker has not been registered with a MBeanServer.");
        }
        ThreadPoolMBean poolMBean = (ThreadPoolMBean)MBeanServerInvocationHandler.newProxyInstance(server, objName, class$org$jboss$util$threadpool$ThreadPoolMBean == null ? (class$org$jboss$util$threadpool$ThreadPoolMBean = ServerInvoker.class$("org.jboss.util.threadpool.ThreadPoolMBean")) : class$org$jboss$util$threadpool$ThreadPoolMBean, false);
        ThreadPool pool = poolMBean.getInstance();
        return pool;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void setMBeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    public synchronized boolean hasInvocationHandler(String subsystem) {
        return this.handlers.containsKey(subsystem);
    }

    public synchronized String[] getSupportedSubsystems() {
        String[] subsystems = new String[this.handlers.size()];
        return this.handlers.keySet().toArray(subsystems);
    }

    public synchronized ServerInvocationHandler[] getInvocationHandlers() {
        ServerInvocationHandler[] ih = new ServerInvocationHandler[this.handlers.size()];
        return this.handlers.values().toArray(ih);
    }

    public synchronized ServerInvocationHandler addInvocationHandler(String subsystem, ServerInvocationHandler handler) {
        handler.setInvoker(this);
        return this.handlers.put(subsystem.toUpperCase(), handler);
    }

    public synchronized ServerInvocationHandler removeInvocationHandler(String subsystem) {
        return (ServerInvocationHandler)this.handlers.remove(subsystem.toUpperCase());
    }

    public synchronized ServerInvocationHandler getInvocationHandler(String subsystem) {
        return (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
    }

    public Object invoke(Object invoke) throws IOException {
        InvocationRequest request = null;
        InvocationResponse response = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("server received invocation =>" + invoke));
        }
        if (invoke != null && invoke instanceof InvocationRequest) {
            request = (InvocationRequest)invoke;
            try {
                Object result = this.invoke(request);
                response = new InvocationResponse(request.getSessionId(), result, false, request.getReturnPayload());
            }
            catch (Throwable throwable) {
                if (this.log.isTraceEnabled()) {
                    throwable.printStackTrace();
                }
                response = new InvocationResponse(request.getSessionId(), throwable, true, request.getReturnPayload());
            }
        } else {
            this.log.error((Object)("server invoker received " + invoke + " as invocation.  Must not be null and must be of type InvocationRequest."));
            response = new InvocationResponse(request.getSessionId(), new Exception("Error processing invocation request on " + this.getLocator() + ".  Either invocation was null or of wrong type."), true, request.getReturnPayload());
        }
        return response;
    }

    public String getDataType() {
        if (this.dataType == null) {
            this.dataType = this.getDataType(this.getLocator());
            if (this.dataType == null) {
                this.dataType = this.getDefaultDataType();
            }
        }
        return this.dataType;
    }

    private String getDataType(InvokerLocator locator) {
        Map params;
        String type = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            type = (String)params.get("datatype");
        }
        return type;
    }

    protected abstract String getDefaultDataType();

    public Object invoke(InvocationRequest invocation) throws Throwable {
        Object param = invocation.getParameter();
        Object result = null;
        if (this.leaseManagement) {
            this.updateClientLease(invocation);
        }
        if ("$PING$".equals(param)) {
            HashMap<String, Long> responseMap = new HashMap<String, Long>();
            responseMap.put(CLIENT_LEASE_PERIOD, new Long(this.leasePeriod));
            return new InvocationResponse(invocation.getSessionId(), Boolean.TRUE, false, responseMap);
        }
        if ("$DISCONNECT$".equals(param)) {
            if (this.leaseManagement) {
                this.terminateLease(invocation);
            }
            return null;
        }
        if (param instanceof OnewayInvocation) {
            this.handleOnewayInvocation((OnewayInvocation)param, invocation);
        } else {
            String subsystem = invocation.getSubsystem();
            String clientId = invocation.getSessionId();
            ServerInvocationHandler handler = null;
            if (subsystem != null) {
                handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
            } else if (!this.handlers.isEmpty()) {
                handler = (ServerInvocationHandler)this.handlers.values().iterator().next();
            }
            if (param instanceof InternalInvocation) {
                result = this.handleInternalInvocation((InternalInvocation)param, invocation, handler);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("dispatching invocation: " + invocation + " to subsystem: " + subsystem + " from client: " + clientId));
                }
                if (handler == null) {
                    throw new InvalidConfigurationException("Can not handle invocation request because there are no ServerInvocationHandlers registered.  Please add via xml configuration or via the Connector's addInvocationHandler() method.");
                }
                result = handler.invoke(invocation);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("dispatch invocation, returning back: " + result + " from subsystem: " + subsystem + " to client: " + clientId));
            }
        }
        return result;
    }

    private void terminateLease(InvocationRequest invocation) {
        String clientSessionId;
        Lease clientLease;
        if (invocation != null && (clientLease = (Lease)this.clientLeases.get(clientSessionId = invocation.getSessionId())) != null) {
            clientLease.terminateLease(this.leasePeriod);
        }
    }

    private void updateClientLease(InvocationRequest invocation) {
        if (invocation != null) {
            String clientSessionId = invocation.getSessionId();
            Lease clientLease = (Lease)this.clientLeases.get(clientSessionId);
            if (clientLease == null) {
                Lease newClientLease = new Lease(clientSessionId, this.leasePeriod, this.locator.getLocatorURI(), invocation.getRequestPayload(), this.connectionNotifier);
                this.clientLeases.put(clientSessionId, newClientLease);
                newClientLease.startLease();
            } else {
                clientLease.updateLease(this.leasePeriod);
            }
        }
    }

    private void handleOnewayInvocation(OnewayInvocation onewayInvocation, InvocationRequest invocation) throws Throwable {
        Object[] objs = onewayInvocation.getParameters();
        Object realParam = objs[0];
        invocation.setParameter(realParam);
        final InvocationRequest newInvocation = invocation;
        ThreadPool executor = this.getOnewayThreadPool();
        Runnable onewayRun = new Runnable(){

            public void run() {
                try {
                    ServerInvoker.this.invoke(newInvocation);
                }
                catch (Throwable e) {
                    ServerInvoker.this.log.error((Object)("Error executing server oneway invocation request: " + newInvocation), e);
                }
            }
        };
        executor.run(onewayRun);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object handleInternalInvocation(InternalInvocation param, InvocationRequest invocation, ServerInvocationHandler handler) throws Throwable {
        List result = null;
        String methodName = param.getMethodName();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("handling InternalInvocation where method name = " + methodName));
        }
        if ("addListener".equals(methodName)) {
            if (handler == null) {
                throw new InvalidConfigurationException("Can not accept a callback listener since there are no ServerInvocationHandlers registered.  Please add via xml configuration or via the Connector's addInvocationHandler() method.");
            }
            ServerInvokerCallbackHandler callbackHandler = this.getCallbackHandler(invocation);
            handler.addListener(callbackHandler);
            return result;
        }
        if ("removeListener".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.removeCallbackHandler(invocation);
            if (callbackHandler == null) {
                String sessionId = ServerInvokerCallbackHandler.getId(invocation);
                throw new RuntimeException("Can not remove callback listener from target server with id of " + sessionId + " as it does not exist as a registered callback listener.");
            }
            if (handler == null) {
                throw new InvalidConfigurationException("Can not remove a callback listener since there are no ServerInvocationHandlers registered.  Please add via xml configuration or via the Connector's addInvocationHandler() method.");
            }
            handler.removeListener(callbackHandler);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("ServerInvoker (" + this + ") removing server callback handler " + callbackHandler + "."));
            }
            callbackHandler.destroy();
            return result;
        }
        if ("getCallbacks".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.getCallbackHandler(invocation);
            if (!this.log.isTraceEnabled()) return callbackHandler.getCallbacks();
            this.log.trace((Object)("ServerInvoker (" + this + ") getting callbacks for callback handler " + callbackHandler + "."));
            return callbackHandler.getCallbacks();
        }
        if ("addClientListener".equals(methodName)) {
            String sessionId = ServerInvokerCallbackHandler.getId(invocation);
            Object[] params = param.getParameters();
            if (params != null && params.length >= 0 && params.length <= 3) {
                InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)params[0];
                Object callbackHandleObject = params[1];
                CallbackContainer callbackContainer = new CallbackContainer(callbackHandler, callbackHandleObject);
                this.clientCallbackListener.put(sessionId, callbackContainer);
                this.log.debug((Object)("ServerInvoker (" + this + ") added client callback handler " + callbackHandler + " with session id of " + sessionId + " and callback handle object of " + callbackHandleObject + "."));
                return result;
            }
            this.log.error((Object)("Recieved addClientListener InternalInvocation, but getParameters() returned: " + params));
            throw new RuntimeException("InvokerCallbackHandler and callback handle object (optional) must be supplied as the only parameter objects within the InternalInvocation when calling addClientListener.");
        }
        if ("removeClientListener".equals(methodName)) {
            String sessionId = ServerInvokerCallbackHandler.getId(invocation);
            this.log.debug((Object)("ServerInvoker (" + this + ") removing client callback handler with session id of " + sessionId + "."));
            Object cbo = this.clientCallbackListener.remove(sessionId);
            if (cbo != null) return result;
            throw new RuntimeException("Can not remove callback listener from callback server with id of " + sessionId + " as it does not exist as a registered callback listener.");
        }
        if ("handleCallback".equals(methodName)) {
            CallbackContainer callbackContainer;
            String sessionId = ServerInvokerCallbackHandler.getId(invocation);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("ServerInvoker (" + this + ") is being asked to deliver callback on client callback handler with session id of " + sessionId + "."));
            }
            if ((callbackContainer = (CallbackContainer)this.clientCallbackListener.get(sessionId)) != null && callbackContainer.getCallbackHandler() != null) {
                Object[] params = param.getParameters();
                Callback callbackRequest = (Callback)params[0];
                HashMap<String, Object> callbackHandleObject = callbackRequest.getReturnPayload();
                if (callbackHandleObject == null) {
                    callbackHandleObject = new HashMap<String, Object>();
                }
                callbackHandleObject.put("callback_handle_object", callbackContainer.getCallbackHandleObject());
                callbackRequest.setReturnPayload(callbackHandleObject);
                InvokerCallbackHandler callbackHandler = callbackContainer.getCallbackHandler();
                callbackHandler.handleCallback(callbackRequest);
                return result;
            }
            this.log.error((Object)("Could not find callback handler to call upon for handleCallback where session id equals " + sessionId));
            return result;
        }
        if (!"addStreamCallback".equals(methodName)) {
            this.log.error((Object)("Error processing InternalInvocation.  Unable to process method " + methodName + ".  Please make sure this should be an InternalInvocation."));
            throw new RuntimeException("Error processing InternalInvocation.  Unable to process method " + methodName);
        }
        StreamHandler streamHandler = this.getStreamHandler(invocation);
        if (handler instanceof StreamInvocationHandler) {
            InternalInvocation inv = (InternalInvocation)invocation.getParameter();
            return ((StreamInvocationHandler)handler).handleStream(streamHandler, inv.getParameters()[1]);
        }
        this.log.error((Object)"Client request is an InputStream, but the registered handlers do not implement the StreamInvocationHandler interface, so could not process call.");
        throw new RuntimeException("No handler registered of proper type (StreamInvocationHandler).");
    }

    private StreamHandler getStreamHandler(InvocationRequest invocation) throws Exception {
        InternalInvocation inv = (InternalInvocation)invocation.getParameter();
        String locator = (String)inv.getParameters()[0];
        StreamHandler streamHandler = new StreamHandler(locator);
        return streamHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInvokerCallbackHandler getCallbackHandler(InvocationRequest invocation) throws Exception {
        ServerInvokerCallbackHandler callbackHandler = null;
        String id = ServerInvokerCallbackHandler.getId(invocation);
        Map map = this.callbackHandlers;
        synchronized (map) {
            callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.get(id);
            if (callbackHandler == null) {
                callbackHandler = new ServerInvokerCallbackHandler(invocation, this.getLocator(), this);
                this.callbackHandlers.put(id, callbackHandler);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("ServerInvoker (" + this + ") adding server callback handler " + callbackHandler + " with id of " + id + "."));
        }
        return callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInvokerCallbackHandler removeCallbackHandler(InvocationRequest invocation) {
        String id = ServerInvokerCallbackHandler.getId(invocation);
        ServerInvokerCallbackHandler callbackHandler = null;
        Map map = this.callbackHandlers;
        synchronized (map) {
            callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.remove(id);
        }
        return callbackHandler;
    }

    protected void preProcess(String sessionId, ClassBytes arg, Map payload, InvokerLocator locator) {
    }

    protected void postProcess(String sessionId, Object param, Map payload, InvokerLocator locator) {
    }

    public void create() {
        if (!this.created) {
            try {
                this.setup();
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting up server invoker " + this, e);
            }
            this.created = true;
        }
    }

    public void start() throws IOException {
        this.started = true;
        this.log.info((Object)("Invoker started for locator: " + this.getLocator()));
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this.started = false;
    }

    public void destroy() {
        if (this.classbyteloader != null) {
            this.classbyteloader.destroy();
        }
    }

    public void setConfiguration(Map configuration) {
        this.configuration = configuration;
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    public String getMBeanObjectName() {
        InvokerLocator locator = this.getLocator();
        StringBuffer buffer = new StringBuffer("jboss.remoting:service=invoker,transport= " + locator.getProtocol());
        buffer.append(",host=" + locator.getHost());
        buffer.append(",port=" + locator.getPort());
        Map param = locator.getParameters();
        if (param != null) {
            Iterator itr = param.keySet().iterator();
            while (itr.hasNext()) {
                buffer.append(",");
                String key = (String)itr.next();
                String value = (String)param.get(key);
                buffer.append(key);
                buffer.append("=");
                buffer.append(value);
            }
        }
        return buffer.toString();
    }

    public void removeCallbackListener(String subsystem, InvokerCallbackHandler callbackHandler) {
        ServerInvocationHandler handler = null;
        if (subsystem != null) {
            handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
        } else if (!this.handlers.isEmpty()) {
            handler = (ServerInvocationHandler)this.handlers.values().iterator().next();
        }
        handler.removeListener(callbackHandler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CallbackContainer {
        private InvokerCallbackHandler handler;
        private Object handleObject;

        public CallbackContainer(InvokerCallbackHandler handler, Object handleObject) {
            this.handler = handler;
            this.handleObject = handleObject;
        }

        public InvokerCallbackHandler getCallbackHandler() {
            return this.handler;
        }

        public Object getCallbackHandleObject() {
            return this.handleObject;
        }
    }
}

