/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.multiplex.MultiplexInvokerConstants;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.AddressPair;
import org.jboss.remoting.transport.socket.SocketClientInvoker;

public class MultiplexClientInvoker
extends SocketClientInvoker
implements MultiplexInvokerConstants {
    private InetAddress connectAddress;
    private String connectHost;
    private int connectPort;
    private InetSocketAddress connectSocketAddress;
    private InetSocketAddress bindSocketAddress;
    private String socketGroupId;
    private MultiplexServerInvoker.SocketGroupInfo socketGroupInfo;
    private AddressPair addressPair;
    private boolean readyToRun;
    protected String clientSocketClassName = (class$org$jboss$remoting$transport$socket$ClientSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ClientSocketWrapper = MultiplexClientInvoker.class$("org.jboss.remoting.transport.socket.ClientSocketWrapper")) : class$org$jboss$remoting$transport$socket$ClientSocketWrapper).getName();
    private Constructor clientSocketConstructor = null;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ClientSocketWrapper;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo;

    public MultiplexClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
    }

    public MultiplexClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
    }

    protected void setup() throws Exception {
        this.log.debug((Object)("configuring MultiplexClientInvoker for: " + this.locator));
        super.setup();
        this.connectAddress = InetAddress.getByName(this.locator.getHost());
        this.connectHost = this.connectAddress.getHostName();
        this.connectPort = this.locator.getPort();
        this.connectSocketAddress = new InetSocketAddress(this.connectAddress, this.connectPort);
        Map parameters = this.configuration;
        if (parameters != null) {
            this.configureSocketGroupParameters(parameters);
        }
    }

    public void finishStart() throws IOException {
        int bindPort;
        if (this.socketGroupInfo != null && this.bindSocketAddress == null) {
            InetAddress bindAddress = this.socketGroupInfo.getBindAddress();
            bindPort = this.socketGroupInfo.getBindPort();
            this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
        }
        if (this.socketGroupInfo != null && this.addressPair == null) {
            String bindHost = this.socketGroupInfo.getBindAddress().getHostName();
            bindPort = this.socketGroupInfo.getBindPort();
            this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
        }
        this.readyToRun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureSocketGroupParameters(Map parameters) throws IOException {
        int bindPort = -1;
        InetAddress bindAddress = null;
        this.socketGroupId = (String)parameters.get("clientMultiplexId");
        this.log.debug((Object)("socketGroupId: " + this.socketGroupId));
        Class clazz = class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo = MultiplexClientInvoker.class$("org.jboss.remoting.transport.multiplex.MultiplexServerInvoker$SocketGroupInfo")) : class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo;
        synchronized (clazz) {
            if (this.socketGroupId != null) {
                this.socketGroupInfo = (MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getSocketGroupMap().get(this.socketGroupId);
            }
            if (this.socketGroupInfo != null && this.socketGroupInfo.getServerInvoker() != null) {
                this.log.debug((Object)"client rule 1");
                InetAddress socketGroupConnectAddress = this.socketGroupInfo.getConnectAddress();
                int socketGroupConnectPort = this.socketGroupInfo.getConnectPort();
                if (socketGroupConnectAddress != null && !socketGroupConnectAddress.equals(this.connectAddress)) {
                    String message = "socket group connect address (" + socketGroupConnectAddress + ") does not match connect address (" + this.connectAddress + ")";
                    this.log.error((Object)message);
                    throw new IOException(message);
                }
                if (socketGroupConnectPort > 0 && socketGroupConnectPort != this.connectPort) {
                    String message = "socket group connect port (" + socketGroupConnectPort + ") does not match connect port (" + this.connectPort + ")";
                    this.log.error((Object)message);
                    throw new IOException(message);
                }
                bindAddress = this.socketGroupInfo.getBindAddress();
                bindPort = this.socketGroupInfo.getBindPort();
                this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
                this.socketGroupInfo.setConnectAddress(this.connectAddress);
                this.socketGroupInfo.setConnectPort(this.connectPort);
                this.socketGroupInfo.addClientInvoker(this);
                if (this.socketGroupInfo.getPrimingSocket() == null) {
                    String connectHost = this.connectAddress.getHostName();
                    MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort);
                }
                String bindHost = bindAddress.getHostName();
                this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
                MultiplexServerInvoker.getAddressPairMap().put(this.addressPair, this.socketGroupInfo);
                MultiplexServerInvoker serverInvoker = this.socketGroupInfo.getServerInvoker();
                if (serverInvoker != null) {
                    serverInvoker.finishStart();
                }
                this.finishStart();
                return;
            }
            String bindHost = (String)parameters.get("multiplexBindHost");
            String bindPortString = (String)parameters.get("multiplexBindPort");
            if (bindHost != null && bindPortString == null) {
                bindPortString = "0";
            }
            if (bindHost == null && bindPortString != null) {
                bindHost = "localhost";
            }
            if (bindHost != null) {
                this.log.debug((Object)"client rule 2");
                try {
                    bindPort = Integer.parseInt(bindPortString);
                }
                catch (NumberFormatException e) {
                    throw new IOException("number format error for bindPort: " + bindPortString);
                }
                this.bindSocketAddress = new InetSocketAddress(bindHost, bindPort);
                this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
                this.socketGroupInfo = (MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getAddressPairMap().get(this.addressPair);
                if (this.socketGroupInfo != null) {
                    this.socketGroupInfo.setConnectAddress(this.connectAddress);
                    this.socketGroupInfo.setConnectPort(this.connectPort);
                    this.socketGroupInfo.addClientInvoker(this);
                    if (this.socketGroupId != null) {
                        String socketGroupSocketGroupId = this.socketGroupInfo.getSocketGroupId();
                        if (socketGroupSocketGroupId != null && !socketGroupSocketGroupId.equals(this.socketGroupId)) {
                            String message = "socket group multiplexId (" + socketGroupSocketGroupId + ") does not match multiplexId (" + this.socketGroupId + ")";
                            this.log.error((Object)message);
                            throw new IOException(message);
                        }
                        if (socketGroupSocketGroupId == null) {
                            this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                            MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                        }
                    }
                    this.finishStart();
                    return;
                }
                this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
                this.socketGroupInfo.setConnectAddress(this.connectAddress);
                this.socketGroupInfo.setConnectPort(this.connectPort);
                this.socketGroupInfo.addClientInvoker(this);
                bindAddress = InetAddress.getByName(bindHost);
                this.socketGroupInfo.setBindAddress(bindAddress);
                this.socketGroupInfo.setBindPort(bindPort);
                String connectHost = this.connectAddress.getHostName();
                MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort);
                MultiplexServerInvoker.getAddressPairMap().put(this.addressPair, this.socketGroupInfo);
                if (this.socketGroupId != null) {
                    this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                    MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                }
                this.finishStart();
                return;
            }
            if (this.socketGroupId != null) {
                this.log.debug((Object)"client rule 3");
                if (this.socketGroupInfo == null) {
                    this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
                    this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                    this.socketGroupInfo.setConnectAddress(this.connectAddress);
                    this.socketGroupInfo.setConnectPort(this.connectPort);
                    MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                }
                this.socketGroupInfo.addClientInvoker(this);
                return;
            }
            this.log.debug((Object)"client rule 4");
            String connectHost = this.connectAddress.getHostName();
            MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort);
            this.finishStart();
        }
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        this.log.debug((Object)"entering transport()");
        if (!this.readyToRun) {
            throw new IOException("connection to server has not been made");
        }
        return super.transport(sessionId, invocation, metadata, marshaller, unmarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDisconnect() {
        this.log.debug((Object)"entering handleDisconnect()");
        super.handleDisconnect();
        Class clazz = class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo = MultiplexClientInvoker.class$("org.jboss.remoting.transport.multiplex.MultiplexServerInvoker$SocketGroupInfo")) : class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo;
        synchronized (clazz) {
            if (this.socketGroupInfo != null) {
                this.socketGroupInfo.removeClientInvoker(this);
                if (this.socketGroupInfo.getClientInvokers().isEmpty() && this.socketGroupInfo.getServerInvoker() == null) {
                    this.log.debug((Object)("invoker group shutting down: " + this.socketGroupInfo.getSocketGroupId()));
                    if (this.socketGroupInfo.getPrimingSocket() != null) {
                        this.log.debug((Object)"MultiplexClientInvoker: closing bind priming socket");
                        try {
                            this.socketGroupInfo.getPrimingSocket().close();
                        }
                        catch (IOException e) {
                            this.log.error((Object)"Error closing bind priming socket during cleanup upon stopping", (Throwable)e);
                        }
                    }
                    this.socketGroupId = this.socketGroupInfo.getSocketGroupId();
                    if (this.socketGroupId != null) {
                        MultiplexServerInvoker.getSocketGroupMap().remove(this.socketGroupId);
                    }
                    if (this.addressPair != null) {
                        MultiplexServerInvoker.getAddressPairMap().remove(this.addressPair);
                    }
                }
                this.socketGroupInfo = null;
            }
        }
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public int getSocketTimeout() {
        return this.timeout;
    }

    protected Socket createSocket(String address, int port) throws IOException {
        this.log.debug((Object)"MultiplexClientInvoker.createSocket()");
        VirtualSocket socket = new VirtualSocket();
        socket.connect(this.connectSocketAddress, this.bindSocketAddress, this.timeout);
        return socket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

