/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.ServerThread;
import org.jboss.remoting.transport.socket.SocketServerInvokerMBean;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SocketServerInvoker
extends ServerInvoker
implements Runnable,
SocketServerInvokerMBean {
    private InetAddress addr;
    private int port;
    static int clientCount = 0;
    private Properties props = new Properties();
    private static int BACKLOG_DEFAULT = 200;
    private static int MAX_POOL_SIZE_DEFAULT = 300;
    public static final String CHECK_CONNECTION_KEY = "socket.check_connection";
    public static final String SERVER_SOCKET_CLASS_FLAG = "serverSocketClass";
    private String serverSocketClass = (class$org$jboss$remoting$transport$socket$ServerSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ServerSocketWrapper = SocketServerInvoker.class$("org.jboss.remoting.transport.socket.ServerSocketWrapper")) : class$org$jboss$remoting$transport$socket$ServerSocketWrapper).getName();
    protected ServerSocket serverSocket = null;
    protected boolean running = false;
    protected int backlog = BACKLOG_DEFAULT;
    protected Thread[] acceptThreads;
    protected int numAcceptThreads = 1;
    protected int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected boolean trace = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerSocketWrapper;

    public SocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected void setup() throws Exception {
        this.props.putAll((Map<?, ?>)this.getConfiguration());
        PropertyEditors.mapJavaBeanProperties((Object)this, (Properties)this.props, (boolean)false);
        super.setup();
        String ssclass = this.props.getProperty(SERVER_SOCKET_CLASS_FLAG);
        if (ssclass != null) {
            this.serverSocketClass = ssclass;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public synchronized void start() throws IOException {
        this.trace = this.log.isTraceEnabled();
        if (!this.running) {
            InetAddress bindAddress = InetAddress.getByName(this.getServerBindAddress());
            if (this.maxPoolSize <= 0) {
                this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
            }
            try {
                this.serverSocket = this.createServerSocket(this.getServerBindPort(), this.backlog, bindAddress);
            }
            catch (IOException e) {
                this.log.error((Object)("Error starting ServerSocket.  Bind port: " + this.getServerBindPort() + ", bind address: " + bindAddress));
                throw e;
            }
            this.clientpool = new LRUPool(2, this.maxPoolSize);
            this.clientpool.create();
            this.threadpool = new LinkedList();
            this.acceptThreads = new Thread[this.numAcceptThreads];
            for (int i = 0; i < this.numAcceptThreads; ++i) {
                if (this.trace) {
                    this.log.trace((Object)"Creating another AcceptThread");
                }
                String name = this.getThreadName(i);
                this.acceptThreads[i] = new Thread((Runnable)this, name);
                if (!this.trace) continue;
                this.log.trace((Object)"Thread accepted");
            }
        }
        try {
            super.start();
        }
        catch (IOException e) {
            this.log.error((Object)"Error starting SocketServerInvoker.", (Throwable)e);
            this.cleanup();
        }
        if (!this.running) {
            this.running = true;
            for (int i = 0; i < this.numAcceptThreads; ++i) {
                this.acceptThreads[i].start();
            }
        }
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        return this.getServerSocketFactory().createServerSocket(serverBindPort, backlog, bindAddress);
    }

    protected String getThreadName(int i) {
        return "SocketServerInvoker#" + i + "-" + this.getServerBindPort();
    }

    public void destroy() {
        if (this.clientpool != null) {
            this.clientpool.destroy();
        }
        super.destroy();
    }

    public synchronized void stop() {
        if (this.running) {
            this.cleanup();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        this.running = false;
        this.maxPoolSize = 0;
        if (this.acceptThreads != null) {
            for (int i = 0; i < this.acceptThreads.length; ++i) {
                try {
                    this.acceptThreads[i].interrupt();
                    continue;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        if (this.clientpool != null) {
            LRUPool i = this.clientpool;
            synchronized (i) {
                Set svrThreads = this.clientpool.getContents();
                Iterator itr = svrThreads.iterator();
                while (itr.hasNext()) {
                    Object o = itr.next();
                    ServerThread st = (ServerThread)o;
                    st.shutdown();
                }
                this.clientpool.flush();
                this.clientpool.stop();
                if (this.threadpool != null) {
                    LinkedList linkedList = this.threadpool;
                    synchronized (linkedList) {
                        for (int i2 = 0; i2 < this.threadpool.size(); ++i2) {
                            ServerThread thread = (ServerThread)this.threadpool.removeFirst();
                            thread.shutdown();
                        }
                    }
                }
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCurrentThreadPoolSize() {
        return this.threadpool.size();
    }

    public int getCurrentClientPoolSize() {
        return this.clientpool.size();
    }

    public int getNumAcceptThreads() {
        return this.numAcceptThreads;
    }

    public void setNumAcceptThreads(int size) {
        this.numAcceptThreads = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog < 0 ? BACKLOG_DEFAULT : backlog;
    }

    public void run() {
        if (this.trace) {
            this.log.trace((Object)"Started execution of method run");
        }
        while (this.running) {
            try {
                if (this.trace) {
                    this.log.trace((Object)"Socket is going to be accepted");
                }
                Socket socket = this.serverSocket.accept();
                if (this.trace) {
                    this.log.trace((Object)("Accepted: " + socket));
                }
                this.processInvocation(socket);
            }
            catch (SSLException e) {
                this.log.error((Object)"SSLServerSocket error", (Throwable)e);
                return;
            }
            catch (Throwable ex) {
                if (!this.running) continue;
                this.log.error((Object)"Failed to accept socket connection", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInvocation(Socket socket) throws Exception {
        Object object;
        ServerThread thread = null;
        boolean newThread = false;
        while (thread == null) {
            object = this.threadpool;
            synchronized (object) {
                if (this.threadpool.size() > 0) {
                    thread = (ServerThread)this.threadpool.removeFirst();
                }
            }
            if (thread != null) continue;
            object = this.clientpool;
            synchronized (object) {
                if (this.clientpool.size() < this.maxPoolSize) {
                    thread = new ServerThread(socket, this, this.clientpool, this.threadpool, this.getTimeout(), this.serverSocketClass);
                    newThread = true;
                }
                if (thread == null) {
                    this.clientpool.evict();
                    if (this.trace) {
                        this.log.trace((Object)"Waiting for a thread...");
                    }
                    ((Object)((Object)this.clientpool)).wait();
                    if (this.trace) {
                        this.log.trace((Object)"Notified of available thread");
                    }
                }
            }
        }
        object = this.clientpool;
        synchronized (object) {
            this.clientpool.insert(thread, thread);
        }
        if (newThread) {
            if (this.trace) {
                this.log.trace((Object)("Created a new thread, t=" + thread));
            }
            thread.start();
        } else {
            if (this.trace) {
                this.log.trace((Object)("Reusing thread t=" + thread));
            }
            thread.wakeup(socket, this.getTimeout(), this.locator.getParameters());
        }
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

