/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.util.TimerUtil;

public class ConnectionValidator
extends TimerTask {
    private List listeners = new ArrayList();
    private Client client = null;
    private long pingPeriod = 2000L;
    protected static final Logger log = Logger.getLogger((String)(class$org$jboss$remoting$ConnectionValidator == null ? (class$org$jboss$remoting$ConnectionValidator = ConnectionValidator.class$("org.jboss.remoting.ConnectionValidator")) : class$org$jboss$remoting$ConnectionValidator).getName());
    public static final long DEFAULT_PING_PERIOD = 2000L;
    static /* synthetic */ Class class$org$jboss$remoting$ConnectionValidator;

    public ConnectionValidator(Client client) {
        this.client = client;
    }

    public ConnectionValidator(Client client, int pingPeriod) {
        this.client = client;
        this.pingPeriod = pingPeriod;
    }

    private void start() {
        TimerUtil.schedule(this, this.pingPeriod);
    }

    private void stop() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        if (listener != null) {
            ConnectionListener connectionListener = listener;
            synchronized (connectionListener) {
                if (this.listeners.size() == 0) {
                    this.start();
                }
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnectionListener(ConnectionListener listener) {
        boolean isRemoved = false;
        if (listener != null) {
            List list = this.listeners;
            synchronized (list) {
                isRemoved = this.listeners.remove(listener);
                if (this.listeners.size() == 0) {
                    this.stop();
                }
            }
        }
        return isRemoved;
    }

    public void run() {
        try {
            boolean isValid = ConnectionValidator.checkConnection(this.client.getInvoker().getLocator(), this.client.getConfiguration());
            if (!isValid) {
                this.notifyListeners(new Exception("Could not connect to server."));
            }
        }
        catch (Throwable thr) {
            this.notifyListeners(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Throwable thr) {
        final Throwable t = thr;
        List list = this.listeners;
        synchronized (list) {
            ListIterator itr = this.listeners.listIterator();
            while (itr.hasNext()) {
                final ConnectionListener listener = (ConnectionListener)itr.next();
                new Thread(){

                    public void run() {
                        listener.handleConnectionException(t, ConnectionValidator.this.client);
                    }
                }.start();
            }
        }
        this.stop();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnection(InvokerLocator locator, Map config) throws Throwable {
        boolean pingWorked = false;
        HashMap<String, String> configMap = config;
        if (configMap == null) {
            configMap = new HashMap<String, String>();
        }
        configMap.put("connection_checker", "true");
        configMap.put("timeout", "1000");
        configMap.put("NumberOfRetries", "1");
        ClientInvoker innerClientInvoker = null;
        try {
            innerClientInvoker = InvokerRegistry.createClientInvoker(locator, configMap);
            if (!innerClientInvoker.isConnected()) {
                innerClientInvoker.connect();
            }
            Object o = innerClientInvoker.invoke(new InvocationRequest(null, "self", "$PING$", null, null, null));
            pingWorked = true;
        }
        catch (Throwable throwable) {
            log.warn((Object)("ConnectionValidator could not successfully ping server (" + innerClientInvoker.getLocator()));
        }
        finally {
            if (innerClientInvoker != null) {
                InvokerRegistry.destroyClientInvoker(locator, configMap);
            }
        }
        return pingWorked;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

