/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.app.client;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.samples.app.client.SeismicSite;

public class SeismicClient
implements NotificationListener {
    private Map sites = new HashMap();
    private static int MSG_COUNT = 0;

    public void setupDetector() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        NetworkRegistry registry = NetworkRegistry.getInstance();
        server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
        SeismicClient.println("NetworkRegistry has been created");
        registry.addNotificationListener(this, null, null);
        SeismicClient.println("NetworkRegistry has added the client as a listener");
        MulticastDetector detector = new MulticastDetector();
        server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
        detector.start();
        SeismicClient.println("MulticastDetector has been created and is listening for new NetworkRegistries to come online");
    }

    public void handleNotification(Notification notification, Object handback) {
        block4: {
            NetworkNotification networkNotification;
            block5: {
                if (!(notification instanceof NetworkNotification)) break block4;
                SeismicClient.println("GOT A NETWORK-REGISTRY NOTIFICATION: " + notification.getType());
                networkNotification = (NetworkNotification)notification;
                if (!"jboss.network.server.added".equals(networkNotification.getType())) break block5;
                SeismicClient.println("New server(s) have been detected.");
                InvokerLocator[] locators = networkNotification.getLocator();
                for (int x = 0; x < locators.length; ++x) {
                    try {
                        InvokerLocator newServerLocator = locators[x];
                        this.createSeismicSite(newServerLocator.getLocatorURI());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                break block4;
            }
            if (!"jboss.network.server.removed".equals(networkNotification.getType())) break block4;
            InvokerLocator[] locators = networkNotification.getLocator();
            for (int x = 0; x < locators.length; ++x) {
                SeismicClient.println("It has been detected that a server has gone down with a locator of: " + locators[x]);
                this.removeSeismicSite(locators[x]);
            }
        }
    }

    private void removeSeismicSite(InvokerLocator locator) {
        SeismicSite site = (SeismicSite)this.sites.get(locator);
        if (site != null) {
            site.disconnect();
        }
    }

    private void createSeismicSite(String locatorURI) {
        SeismicSite newSite = new SeismicSite(locatorURI);
        try {
            newSite.connect();
            this.sites.put(locatorURI, newSite);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void makeInvocation(String locatorURI) throws Throwable {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        SeismicClient.println("Sending welcome message to remoting server with locator uri of: " + locatorURI);
        Client remotingClient = new Client(locator);
        remotingClient.connect();
        Object response = remotingClient.invoke("Welcome Aboard!", null);
        remotingClient.disconnect();
        SeismicClient.println("The newly discovered server sent this response to our welcome message: " + response);
    }

    public static void main(String[] args) {
        SeismicClient.println("Starting JBoss/Remoting client... to stop this client, kill it manually via Control-C");
        SeismicClient client = new SeismicClient();
        try {
            client.setupDetector();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            SeismicClient.println("Stopping JBoss/Remoting client");
            return;
        }
    }

    public static void println(String msg) {
        System.out.println(++MSG_COUNT + ". [CLIENT]: " + msg);
    }
}

