/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.app.client;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.samples.app.SeismicSiteData;
import org.jboss.remoting.samples.app.SeismicSiteInfo;
import org.jboss.remoting.transport.Connector;

public class SeismicSite {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 7777;
    private String locatorURI = null;
    private Client remotingClient = null;
    private SeismicSiteInfo siteInfo = null;
    private SeismicSiteData siteData = null;
    private Connector callbackServerConnector;

    public SeismicSite(String locatorURI) {
        this.locatorURI = locatorURI;
    }

    public void connect() throws Throwable {
        System.out.println("Creating remoting client connecting to " + this.locatorURI);
        InvokerLocator locator = new InvokerLocator(this.locatorURI);
        this.remotingClient = new Client(locator);
        this.remotingClient.connect();
        this.siteInfo = (SeismicSiteInfo)this.remotingClient.invoke("getSiteInfo");
        System.out.println("Seismic site info - " + this.siteInfo);
        this.callbackServerConnector = this.setupCallbackServer();
    }

    private Connector setupCallbackServer() throws Throwable {
        String callbackLocatorURI = transport + "://" + host + ":" + port++;
        InvokerLocator callbackLocator = new InvokerLocator(callbackLocatorURI);
        System.out.println("Starting remoting server with locator uri of: " + callbackLocator);
        this.callbackServerConnector = new Connector();
        this.callbackServerConnector.setInvokerLocator(callbackLocator.getLocatorURI());
        this.callbackServerConnector.start();
        SiteDataCallbackHandler callbackHandler = new SiteDataCallbackHandler();
        this.remotingClient.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, null);
        return this.callbackServerConnector;
    }

    public void disconnect() {
        if (this.remotingClient != null) {
            this.remotingClient.disconnect();
        }
        if (this.callbackServerConnector != null) {
            this.callbackServerConnector.stop();
            this.callbackServerConnector.destroy();
        }
    }

    private class SiteDataCallbackHandler
    implements InvokerCallbackHandler {
        private SiteDataCallbackHandler() {
        }

        public void handleCallback(Callback callback) throws HandleCallbackException {
            Object obj = callback.getCallbackObject();
            if (obj instanceof SeismicSiteData) {
                SeismicSite.this.siteData = (SeismicSiteData)obj;
                System.out.println("Received seismic site data update from " + SeismicSite.this.siteInfo);
                System.out.println(SeismicSite.this.siteData);
            }
        }
    }
}

