/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.app.server;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.samples.app.SeismicSiteData;
import org.jboss.remoting.samples.app.SeismicSiteInfo;
import org.jboss.remoting.stream.StreamInvocationHandler;

public class SeismicHandler
implements StreamInvocationHandler,
Runnable {
    private SeismicSiteInfo siteInfo = null;
    private List siteDataListeners = new ArrayList();
    private boolean shouldGenerateCallbacks = false;

    public SeismicHandler(String city) {
        this.siteInfo = new SeismicSiteInfo(city);
        Thread callbackThread = new Thread(this);
        callbackThread.setDaemon(true);
        callbackThread.start();
    }

    public Object handleStream(InputStream stream, InvocationRequest param) {
        return null;
    }

    public void setMBeanServer(MBeanServer server) {
    }

    public void setInvoker(ServerInvoker invoker) {
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        String methodCall;
        SeismicSiteInfo ret = null;
        Object payload = invocation.getParameter();
        if (payload instanceof String && "getSiteInfo".equals(methodCall = (String)payload)) {
            ret = this.siteInfo;
        }
        return ret;
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
        System.out.println("Adding callback listener.");
        this.siteDataListeners.add(callbackHandler);
        this.shouldGenerateCallbacks = true;
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
        System.out.println("Removing callback listener.");
        this.siteDataListeners.remove(callbackHandler);
        if (this.siteDataListeners.size() == 0) {
            this.shouldGenerateCallbacks = false;
        }
    }

    public void run() {
        while (true) {
            if (this.shouldGenerateCallbacks) {
                SeismicSiteData siteData = this.generateSeismicSiteData();
                Callback callback = new Callback(siteData);
                Iterator itr = this.siteDataListeners.iterator();
                while (itr.hasNext()) {
                    InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)itr.next();
                    try {
                        callbackHandler.handleCallback(callback);
                    }
                    catch (HandleCallbackException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private SeismicSiteData generateSeismicSiteData() {
        SeismicSiteData siteData = new SeismicSiteData();
        siteData.setDepth(new Random().nextFloat() + "");
        siteData.setLatitude(new Random().nextFloat() + "");
        siteData.setLatitude(new Random().nextFloat() + "");
        siteData.setMagnitude(new Random().nextFloat() + "");
        return siteData;
    }
}

