/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SocketId
implements Serializable {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$SocketId == null ? (class$org$jboss$remoting$transport$multiplex$SocketId = SocketId.class$("org.jboss.remoting.transport.multiplex.SocketId")) : class$org$jboss$remoting$transport$multiplex$SocketId));
    private static final String ISO_8859_1 = "ISO-8859-1";
    public static final int PROTOCOL_PORT = -1;
    public static final int SERVER_SOCKET_PORT = -2;
    public static final int SERVER_SOCKET_CONNECT_PORT = -3;
    public static final int SERVER_SOCKET_VERIFY_PORT = -4;
    public static final int BACKCHANNEL_PORT = -5;
    public static final int DEADLETTER_PORT = -6;
    public static final int INITIAL_OUTPUT_PORT = -7;
    private static final int MIN_PORT = -7;
    private static int maxPort = 0x7FFFFFFE;
    public static final SocketId PROTOCOL_SOCKET_ID = new SocketId(-1);
    public static final SocketId SERVER_SOCKET_ID = new SocketId(-2);
    public static final SocketId SERVER_SOCKET_CONNECT_ID = new SocketId(-3);
    public static final SocketId SERVER_SOCKET_VERIFY_ID = new SocketId(-4);
    public static final SocketId BACKCHANNEL_SOCKET_ID = new SocketId(-5);
    public static final SocketId DEADLETTER_SOCKET_ID = new SocketId(-6);
    public static final SocketId INITIAL_OUTPUT_SOCKET_ID = new SocketId(-7);
    private static HashSet portsInUse = new HashSet();
    private static int nextNewPort = 1;
    private static boolean hasWrapped = false;
    private int port;
    byte[] bytes;
    private static final long serialVersionUID = 1126328489938867931L;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$SocketId;

    public SocketId() {
        this.port = SocketId.getFreePort();
        this.setBytes(this.port);
    }

    public SocketId(int port) throws IOException {
        this.checkPortValue(port);
        this.port = port;
        this.setBytes(port);
    }

    public SocketId(byte[] bytes) throws IOException {
        this.bytes = bytes;
        this.setPort(bytes);
        this.checkPortValue(this.port);
    }

    protected SocketId(short port) {
        this.port = port;
        this.setBytes(port);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public int getPort() {
        return this.port;
    }

    public void releasePort() {
        SocketId.freePort(this.port);
    }

    public static void setMaxPort(int max) {
        maxPort = max;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SocketId)) {
            return false;
        }
        return this.port == ((SocketId)o).port;
    }

    public int hashCode() {
        return this.port;
    }

    public String toString() {
        return Integer.toString(this.port);
    }

    protected void checkPortValue(int port) throws IOException {
        if (port < -7) {
            log.error((Object)("attempt to create port with illegal value: " + port));
            throw new IOException("attempt to create port with illegal value: " + port);
        }
    }

    protected void setPort(byte[] bytes) {
        try {
            this.port = Integer.parseInt(new String(bytes, ISO_8859_1));
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
        }
        catch (RuntimeException r) {
            log.error((Object)"problem with port: ");
            for (int i = 0; i < bytes.length; ++i) {
                log.error((Object)("" + bytes[i]));
            }
            throw r;
        }
    }

    protected void setBytes(int port) {
        try {
            this.bytes = Integer.toString(port).getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
        }
    }

    protected static synchronized void freePort(int port) {
        portsInUse.remove(new Integer(port));
        (class$org$jboss$remoting$transport$multiplex$SocketId == null ? (class$org$jboss$remoting$transport$multiplex$SocketId = SocketId.class$("org.jboss.remoting.transport.multiplex.SocketId")) : class$org$jboss$remoting$transport$multiplex$SocketId).notifyAll();
    }

    protected static synchronized int getFreePort() {
        if (nextNewPort > maxPort) {
            nextNewPort = 1;
            hasWrapped = true;
        }
        if (hasWrapped) {
            int n;
            int port;
            Integer portInteger;
            if (portsInUse.size() >= maxPort) {
                try {
                    (class$org$jboss$remoting$transport$multiplex$SocketId == null ? (class$org$jboss$remoting$transport$multiplex$SocketId = SocketId.class$("org.jboss.remoting.transport.multiplex.SocketId")) : class$org$jboss$remoting$transport$multiplex$SocketId).wait();
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            do {
                if (nextNewPort > maxPort) {
                    n = 1;
                    continue;
                }
                int n2 = nextNewPort;
                n = n2;
                nextNewPort = n2 + 1;
            } while (portsInUse.contains(portInteger = new Integer(port = n)));
            portsInUse.add(portInteger);
            return port;
        }
        int port = nextNewPort++;
        Integer portInteger = new Integer(port);
        portsInUse.add(portInteger);
        return port;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

