/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.Invoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.security.SSLSocketBuilder;

public abstract class AbstractInvoker
implements Invoker {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected ClassByteClassLoader classbyteloader;
    protected InvokerLocator locator;
    protected Map localServerLocators = new HashMap();
    protected String serializationType;
    protected Map configuration = new HashMap();
    protected SocketFactory socketFactory;
    protected boolean socketFactoryCreatedFromSSLParameters;

    public AbstractInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public AbstractInvoker(InvokerLocator locator, Map configuration) {
        this.classbyteloader = new ClassByteClassLoader(this.getClass().getClassLoader());
        this.locator = locator;
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
        if (locator.getParameters() != null) {
            this.configuration.putAll(locator.getParameters());
        }
        try {
            InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
            if (loaderLocator != null) {
                this.classbyteloader.setClientInvoker(new Client(loaderLocator));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not create remote class loading for invoker.", (Throwable)e);
        }
        if (locator == null || locator.getParameters() == null) {
            this.setSerializationType("java");
        } else {
            this.setSerializationType(locator.findSerializationType());
        }
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void addClientLocator(String listenerId, InvokerLocator locator) {
        InvokerLocator obj = this.localServerLocators.put(listenerId, locator);
        if (obj != null) {
            throw new RuntimeException("InvokerLocator already exists for listener id " + listenerId + ".  " + "Remove this listener before adding again.");
        }
    }

    public InvokerLocator getClientLocator(String listenerId) {
        return (InvokerLocator)this.localServerLocators.get(listenerId);
    }

    public synchronized void setClassLoader(ClassLoader classloader) {
        this.classbyteloader = new ClassByteClassLoader(classloader);
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classbyteloader;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public boolean isSocketFactoryCreatedFromSSLParameters() {
        return this.socketFactoryCreatedFromSSLParameters;
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        String socketFactoryString;
        if (configuration == null) {
            return null;
        }
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        SocketFactory factory = null;
        Object obj = configuration.get("customSocketFactory");
        if (obj != null) {
            if (obj instanceof SocketFactory) {
                factory = (SocketFactory)obj;
            } else {
                throw new RuntimeException("Can not set custom socket factory (" + obj + ") as is not of type javax.net.SocketFactory");
            }
        }
        if (factory == null && (socketFactoryString = (String)configuration.get("socketFactory")) != null && socketFactoryString.length() > 0) {
            ClassLoader classLoader = null;
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                Class<?> cl = classLoader.loadClass(socketFactoryString);
                Constructor<?> socketFactoryConstructor = null;
                socketFactoryConstructor = cl.getConstructor(new Class[0]);
                factory = (SocketFactory)socketFactoryConstructor.newInstance(new Object[0]);
                this.log.trace((Object)("SocketFactory (" + socketFactoryString + ") loaded"));
            }
            catch (Exception e) {
                this.log.debug((Object)("Could not create socket factory by classname (" + socketFactoryString + ").  Error message: " + e.getMessage()));
            }
        }
        if (factory == null && AbstractInvoker.needsCustomSSLConfiguration(configuration)) {
            try {
                SSLSocketBuilder socketBuilder = new SSLSocketBuilder(configuration);
                socketBuilder.setUseSSLSocketFactory(false);
                factory = socketBuilder.createSSLSocketFactory();
                this.socketFactoryCreatedFromSSLParameters = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create customized SSL socket factory", e);
            }
        }
        return factory;
    }

    public static boolean needsCustomSSLConfiguration(Map configuration) {
        return configuration.get("org.jboss.remoting.keyAlias") != null || configuration.get("org.jboss.remoting.clientAuthMode") != null || configuration.get("org.jboss.remoting.serverAuthMode") != null || configuration.get("org.jboss.remoting.sslProtocol") != null || configuration.get("org.jboss.remoting.sslProviderName") != null || configuration.get("org.jboss.remoting.serversocket.useClientMode") != null || configuration.get("org.jboss.remoting.socket.useClientMode") != null || configuration.get("org.jboss.remoting.keyPassword") != null || configuration.get("org.jboss.remoting.keyStoreAlgorithm") != null || configuration.get("org.jboss.remoting.keyStore") != null || configuration.get("org.jboss.remoting.keyStorePassword") != null || configuration.get("org.jboss.remoting.keyStoreType") != null || configuration.get("org.jboss.remoting.trustStoreAlgorithm") != null || configuration.get("org.jboss.remoting.trustStore") != null || configuration.get("org.jboss.remoting.trustStorePassword") != null || configuration.get("org.jboss.remoting.trustStoreType") != null;
    }
}

