/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.Map;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionNotifier;
import org.jboss.remoting.util.TimerUtil;

public class Lease {
    private ConnectionNotifier notifier = null;
    private String clientSessionId = null;
    private long leasePeriod = -1L;
    private String locatorURL = null;
    private Map requestPayload = null;
    private LeaseTimerTask leaseTimerTask = null;
    private long leaseWindow = -1L;
    private long pingStart = -1L;
    private Map clientLeases = null;
    private boolean leaseUpdated = false;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$Lease == null ? (class$org$jboss$remoting$Lease = Lease.class$("org.jboss.remoting.Lease")) : class$org$jboss$remoting$Lease));
    static /* synthetic */ Class class$org$jboss$remoting$Lease;

    public Lease(String clientSessionId, long leasePeriod, String locatorurl, Map requestPayload, ConnectionNotifier notifier, Map clientLeases) {
        this.clientSessionId = clientSessionId;
        this.leasePeriod = leasePeriod;
        this.notifier = notifier;
        this.locatorURL = locatorurl;
        this.requestPayload = requestPayload;
        this.leaseWindow = leasePeriod * 2L;
        this.clientLeases = clientLeases;
    }

    public void startLease() {
        this.leaseTimerTask = new LeaseTimerTask();
        TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
    }

    public void updateLease(long leasePeriod) {
        long pingDuration;
        this.leaseUpdated = true;
        if (leasePeriod != this.leasePeriod) {
            this.leasePeriod = leasePeriod;
            this.leaseWindow = leasePeriod * 2L;
            this.stopLease();
            this.startLease();
        } else if (this.pingStart != -1L && (double)(pingDuration = System.currentTimeMillis() - this.pingStart) > 0.75 * (double)this.leaseWindow) {
            this.leaseWindow = pingDuration * 2L;
            this.stopLease();
            this.leaseTimerTask = new LeaseTimerTask();
            TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
        }
        this.pingStart = System.currentTimeMillis();
    }

    public void terminateLease(long leasePeriod) {
        this.stopLease();
        this.notifier.connectionTerminated(this.locatorURL, this.clientSessionId, this.requestPayload);
    }

    private void stopLease() {
        this.leaseTimerTask.cancel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LeaseTimerTask
    extends TimerTask {
        private LeaseTimerTask() {
        }

        public void run() {
            if (Lease.this.leaseUpdated) {
                Lease.this.leaseUpdated = false;
            } else {
                Lease.this.stopLease();
                Lease.this.notifier.connectionLost(Lease.this.locatorURL, Lease.this.clientSessionId, Lease.this.requestPayload);
                if (Lease.this.clientLeases != null) {
                    Lease.this.clientLeases.remove(Lease.this.clientSessionId);
                }
            }
        }
    }
}

