/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.SerializableStore;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.CallbackErrorHandler;
import org.jboss.remoting.callback.DefaultCallbackErrorHandler;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.NullCallbackStore;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.SSLSocketBuilderMBean;
import org.jboss.remoting.security.SSLSocketFactoryService;

public class ServerInvokerCallbackHandler
implements InvokerCallbackHandler {
    private InvocationRequest invocation;
    private Client callBackClient;
    private ArrayList callbacks = new ArrayList();
    private String sessionId;
    private String clientSessionId;
    private InvokerLocator serverLocator;
    private SerializableStore callbackStore = null;
    private CallbackErrorHandler callbackErrorHandler = null;
    public static final String CALLBACK_STORE_KEY = "callbackStore";
    public static final String CALLBACK_ERROR_HANDLER_KEY = "callbackErrorHandler";
    public static final String CALLBACK_MEM_CEILING = "callbackMemCeiling";
    private double memPercentCeiling = 20.0;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$callback$ServerInvokerCallbackHandler == null ? (class$org$jboss$remoting$callback$ServerInvokerCallbackHandler = ServerInvokerCallbackHandler.class$("org.jboss.remoting.callback.ServerInvokerCallbackHandler")) : class$org$jboss$remoting$callback$ServerInvokerCallbackHandler));
    static /* synthetic */ Class class$org$jboss$remoting$callback$ServerInvokerCallbackHandler;
    static /* synthetic */ Class class$org$jboss$remoting$security$SSLServerSocketFactoryServiceMBean;
    static /* synthetic */ Class class$org$jboss$remoting$SerializableStore;
    static /* synthetic */ Class class$org$jboss$remoting$callback$CallbackErrorHandler;

    public ServerInvokerCallbackHandler(InvocationRequest invocation, InvokerLocator serverLocator, ServerInvoker owner) throws Exception {
        if (invocation == null) {
            throw new Exception("Can not construct ServerInvokerCallbackHandler with null InvocationRequest.");
        }
        this.invocation = invocation;
        this.serverLocator = serverLocator;
        this.init(invocation, owner);
    }

    private void init(InvocationRequest invocation, ServerInvoker owner) throws Exception {
        this.clientSessionId = invocation.getSessionId();
        this.sessionId = ServerInvokerCallbackHandler.getId(invocation);
        if (invocation.getLocator() != null) {
            HashMap clientConfig = new HashMap();
            if (owner.getConfiguration() != null) {
                clientConfig.putAll(owner.getConfiguration());
            }
            this.configureSocketFactory(clientConfig, owner);
            this.callBackClient = new Client(invocation.getLocator(), invocation.getSubsystem(), clientConfig);
            this.callBackClient.connect();
            this.createCallbackErrorHandler(owner, invocation.getSubsystem());
        } else {
            this.createCallbackStore(owner, this.sessionId);
        }
        log.debug((Object)("Session id for callback handler is " + this.sessionId));
    }

    private void configureSocketFactory(Map clientConfig, ServerInvoker serverInvoker) throws Exception {
        if (serverInvoker.getSocketFactory() != null) {
            clientConfig.put("customSocketFactory", serverInvoker.getSocketFactory());
            return;
        }
        if (clientConfig == null) {
            clientConfig = new HashMap<String, SocketFactory>();
        }
        if (clientConfig.containsKey("customSocketFactory")) {
            serverInvoker.setSocketFactory((SocketFactory)clientConfig.get("customSocketFactory"));
            return;
        }
        String serverSocketFactoryString = (String)clientConfig.get("serverSocketFactory");
        if (serverSocketFactoryString != null && serverSocketFactoryString.length() > 0) {
            MBeanServer server = serverInvoker.getMBeanServer();
            try {
                SSLSocketBuilderMBean sslSocketBuilder;
                boolean isCorrectType;
                ObjectName serverSocketFactoryObjName = new ObjectName(serverSocketFactoryString);
                if (server != null && (isCorrectType = server.isInstanceOf(serverSocketFactoryObjName, (class$org$jboss$remoting$security$SSLServerSocketFactoryServiceMBean == null ? (class$org$jboss$remoting$security$SSLServerSocketFactoryServiceMBean = ServerInvokerCallbackHandler.class$("org.jboss.remoting.security.SSLServerSocketFactoryServiceMBean")) : class$org$jboss$remoting$security$SSLServerSocketFactoryServiceMBean).getName())) && (sslSocketBuilder = (SSLSocketBuilderMBean)server.getAttribute(serverSocketFactoryObjName, "SSLSocketBuilder")) != null) {
                    SSLSocketBuilder clonedSSLSocketBuilder = (SSLSocketBuilder)sslSocketBuilder.clone();
                    boolean shouldUseDefault = sslSocketBuilder.getUseSSLServerSocketFactory();
                    clonedSSLSocketBuilder.setUseSSLSocketFactory(shouldUseDefault);
                    boolean useClientMode = sslSocketBuilder.isServerSocketUseClientMode();
                    clonedSSLSocketBuilder.setSocketUseClientMode(useClientMode);
                    SSLSocketFactoryService sslSocketFactoryService = new SSLSocketFactoryService();
                    sslSocketFactoryService.setSSLSocketBuilder(clonedSSLSocketBuilder);
                    sslSocketFactoryService.start();
                    clientConfig.put("customSocketFactory", sslSocketFactoryService);
                    clientConfig.put("org.jboss.remoting.socket.useClientMode", (SocketFactory)((Object)"false"));
                    clientConfig.put("hostnameVerifier", (SocketFactory)((Object)"org.jboss.test.remoting.transport.http.ssl.config.SelfIdentifyingHostnameVerifier"));
                    serverInvoker.setSocketFactory(sslSocketFactoryService);
                    return;
                }
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        if (serverInvoker.getServerSocketFactory() instanceof SSLServerSocketFactory && !clientConfig.containsKey("org.jboss.remoting.socket.useClientMode")) {
            clientConfig.put("org.jboss.remoting.socket.useClientMode", (SocketFactory)((Object)"false"));
        }
    }

    public String getCallbackSessionId() {
        return this.sessionId;
    }

    public String getClientSessionId() {
        return this.clientSessionId;
    }

    public String getSubsystem() {
        return this.invocation.getSubsystem();
    }

    public void setMemPercentCeiling(Double ceiling) {
        if (ceiling != null) {
            this.memPercentCeiling = ceiling;
        }
    }

    public Double getMemPercentCeiling() {
        return new Double(this.memPercentCeiling);
    }

    private void createCallbackStore(ServerInvoker owner, String sessionId) throws Exception {
        block11: {
            String storeName;
            Map config = owner.getConfiguration();
            if (config != null && (storeName = (String)config.get(CALLBACK_STORE_KEY)) != null) {
                try {
                    MBeanServer server = owner.getMBeanServer();
                    ObjectName storeObjectName = new ObjectName(storeName);
                    if (server != null) {
                        this.callbackStore = (SerializableStore)MBeanServerInvocationHandler.newProxyInstance(server, storeObjectName, class$org$jboss$remoting$SerializableStore == null ? (class$org$jboss$remoting$SerializableStore = ServerInvokerCallbackHandler.class$("org.jboss.remoting.SerializableStore")) : class$org$jboss$remoting$SerializableStore, false);
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)("Could not create callback store from the configration value given (" + storeName + ") as an MBean."));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Error is: " + ex.getMessage()), (Throwable)ex);
                    }
                    this.callbackStore = null;
                }
                if (this.callbackStore == null) {
                    try {
                        Class<?> storeClass = Class.forName(storeName);
                        this.callbackStore = (SerializableStore)storeClass.newInstance();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Could not create callback store from the configuration value given (" + storeName + ") as a fully qualified class name."));
                        if (!log.isTraceEnabled()) break block11;
                        log.trace((Object)("Error is: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        if (this.callbackStore == null) {
            this.callbackStore = new NullCallbackStore();
        } else {
            HashMap<String, String> storeConfig = new HashMap<String, String>();
            storeConfig.putAll(owner.getConfiguration());
            String newFilePath = null;
            String filePath = (String)storeConfig.get("StoreFilePath");
            if (filePath == null) {
                newFilePath = System.getProperty("jboss.server.data.dir", "data");
            }
            newFilePath = newFilePath + System.getProperty("file.separator") + "remoting" + System.getProperty("file.separator") + sessionId;
            storeConfig.put("StoreFilePath", newFilePath);
            this.callbackStore.setConfig(storeConfig);
        }
        this.callbackStore.create();
        this.callbackStore.start();
        this.configureMemCeiling(owner.getConfiguration());
    }

    private void createCallbackErrorHandler(ServerInvoker owner, String subsystem) throws Exception {
        block9: {
            String errorHandlerName;
            Map config = owner.getConfiguration();
            if (config != null && (errorHandlerName = (String)config.get(CALLBACK_ERROR_HANDLER_KEY)) != null) {
                try {
                    MBeanServer server = owner.getMBeanServer();
                    ObjectName errorHandlerObjectName = new ObjectName(errorHandlerName);
                    if (server != null) {
                        this.callbackErrorHandler = (CallbackErrorHandler)MBeanServerInvocationHandler.newProxyInstance(server, errorHandlerObjectName, class$org$jboss$remoting$callback$CallbackErrorHandler == null ? (class$org$jboss$remoting$callback$CallbackErrorHandler = ServerInvokerCallbackHandler.class$("org.jboss.remoting.callback.CallbackErrorHandler")) : class$org$jboss$remoting$callback$CallbackErrorHandler, false);
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)("Could not create callback error handler from the configration value given (" + errorHandlerName + ") as an MBean."));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Error is: " + ex.getMessage()), (Throwable)ex);
                    }
                    this.callbackErrorHandler = null;
                }
                if (this.callbackStore == null) {
                    try {
                        Class<?> errorHandlerClass = Class.forName(errorHandlerName);
                        this.callbackErrorHandler = (CallbackErrorHandler)errorHandlerClass.newInstance();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Could not create callback error handler from the configuration value given (" + errorHandlerName + ") as a fully qualified class name."));
                        if (!log.isTraceEnabled()) break block9;
                        log.trace((Object)("Error is: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        if (this.callbackErrorHandler == null) {
            this.callbackErrorHandler = new DefaultCallbackErrorHandler();
        }
        HashMap<String, String> errorHandlerConfig = new HashMap<String, String>();
        errorHandlerConfig.putAll(owner.getConfiguration());
        errorHandlerConfig.put("handlerSubsystem", subsystem);
        this.callbackErrorHandler.setConfig(errorHandlerConfig);
        this.callbackErrorHandler.setServerInvoker(owner);
        this.callbackErrorHandler.setCallbackHandler(this);
    }

    private void configureMemCeiling(Map configuration) {
        String ceiling;
        if (configuration != null && (ceiling = (String)configuration.get(CALLBACK_MEM_CEILING)) != null) {
            try {
                double newCeiling = Double.parseDouble(ceiling);
                this.setMemPercentCeiling(new Double(newCeiling));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Found new store memory ceiling seting (" + ceiling + "), but can not convert to type double."), (Throwable)e);
            }
        }
    }

    public Client getCallbackClient() {
        return this.callBackClient;
    }

    public static String getId(InvocationRequest invocation) {
        String listenerId;
        String sessionId = invocation.getSessionId();
        Map metadata = invocation.getRequestPayload();
        if (metadata != null && (listenerId = (String)metadata.get("listenerId")) != null) {
            sessionId = sessionId + "+" + listenerId;
        }
        return sessionId;
    }

    public String getId() {
        return ServerInvokerCallbackHandler.getId(this.invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCallbacks() {
        List callbackList = null;
        ArrayList arrayList = this.callbacks;
        synchronized (arrayList) {
            callbackList = (List)this.callbacks.clone();
            this.callbacks.clear();
        }
        List persistedCallbacks = null;
        try {
            persistedCallbacks = this.getPersistedCallbacks();
        }
        catch (IOException e) {
            log.error((Object)"Can not get persisted callbacks.", (Throwable)e);
            throw new RuntimeException("Error getting callbacks", e);
        }
        callbackList.addAll(persistedCallbacks);
        return callbackList;
    }

    private List getPersistedCallbacks() throws IOException {
        ArrayList<Object> callbacks = new ArrayList<Object>();
        int size = this.callbackStore.size();
        for (int x = 0; x < size; ++x) {
            callbacks.add(this.callbackStore.getNext());
            if (!this.isMemLow()) continue;
            new Thread(){

                public void run() {
                    System.gc();
                }
            }.start();
            break;
        }
        return callbacks;
    }

    public boolean isPullCallbackHandler() {
        return this.callBackClient == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCallback(Callback callback) throws HandleCallbackException {
        block16: {
            try {
                if (this.callBackClient == null) {
                    if (this.shouldPersist()) {
                        try {
                            this.persistCallback(callback);
                            callback = null;
                            new Thread(){

                                public void run() {
                                    System.gc();
                                }
                            }.start();
                            break block16;
                        }
                        catch (IOException e) {
                            log.error((Object)"Unable to persist callback.", (Throwable)e);
                            throw new HandleCallbackException("Unable to persist callback and will not be able to deliver.", e);
                        }
                    }
                    ArrayList e = this.callbacks;
                    synchronized (e) {
                        if (log.isTraceEnabled()) {
                            log.debug((Object)"pull callback.  adding to callback list");
                        }
                        this.callbacks.add(callback);
                        break block16;
                    }
                }
                try {
                    if (log.isTraceEnabled()) {
                        log.debug((Object)"push callback.  Calling client now.");
                    }
                    if (callback != null) {
                        HashMap<String, InvokerLocator> returnPayload = callback.getReturnPayload();
                        if (returnPayload == null) {
                            returnPayload = new HashMap<String, InvokerLocator>();
                        }
                        returnPayload.put("server_locator", this.serverLocator);
                        callback.setReturnPayload(returnPayload);
                    }
                    InternalInvocation internalInvocation = new InternalInvocation("handleCallback", new Object[]{callback});
                    this.callBackClient.setSessionId(this.sessionId);
                    this.callBackClient.invoke(internalInvocation, callback.getRequestPayload());
                }
                catch (Throwable ex) {
                    if (this.callbackErrorHandler != null) {
                        this.callbackErrorHandler.handleError(ex);
                        break block16;
                    }
                    log.debug((Object)"Error dispatching callback to handler.", ex);
                    throw new HandleCallbackException("Error dispatching callback to handler.", ex);
                }
            }
            catch (Throwable thr) {
                log.error((Object)"Error handling callback.", thr);
                throw new HandleCallbackException("Error handling callback.", thr);
            }
        }
    }

    private void persistCallback(InvocationRequest callback) throws IOException {
        this.callbackStore.add(callback);
    }

    private boolean shouldPersist() {
        return this.isMemLow();
    }

    private boolean isMemLow() {
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        float percentage = 100L * free / total;
        return max == total && this.memPercentCeiling >= (double)percentage;
    }

    public String toString() {
        return this.getClass().getName() + " - id: " + this.getId();
    }

    public void destroy() {
        if (this.callBackClient != null) {
            this.callBackClient.disconnect();
            this.callBackClient = null;
        }
        if (this.callbackStore != null) {
            this.callbackStore.purgeFiles();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

