/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex.utility;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.utility.GrowablePipedInputStream;

public class VirtualSelector {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$utility$VirtualSelector == null ? (class$org$jboss$remoting$transport$multiplex$utility$VirtualSelector = VirtualSelector.class$("org.jboss.remoting.transport.multiplex.utility.VirtualSelector")) : class$org$jboss$remoting$transport$multiplex$utility$VirtualSelector));
    private Map attachmentMap = new HashMap();
    private Map readyMap = new HashMap();
    private Map readyMapCopy = new HashMap();
    private Set removableStreams = new HashSet();
    private boolean open = true;
    private boolean closed;
    private boolean inUse;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$utility$VirtualSelector;

    public synchronized void register(GrowablePipedInputStream inputStream, Object attachment) {
        this.attachmentMap.put(inputStream, attachment);
    }

    public synchronized void unregister(InputStream inputStream) {
        this.attachmentMap.remove(inputStream);
        this.readyMap.remove(inputStream);
        this.removableStreams.add(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map select() {
        if (this.closed) {
            return null;
        }
        Iterator it = this.removableStreams.iterator();
        while (it.hasNext()) {
            this.readyMapCopy.remove(it.next());
        }
        this.removableStreams.clear();
        this.readyMapCopy.putAll(this.readyMap);
        this.readyMap.clear();
        if (!this.readyMapCopy.isEmpty()) {
            return this.readyMapCopy;
        }
        while (this.readyMap.isEmpty() && this.open) {
            try {
                this.inUse = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                this.inUse = false;
            }
        }
        if (this.readyMap.isEmpty()) {
            log.debug((Object)"returning null");
            this.finishClose();
            return null;
        }
        this.readyMapCopy.putAll(this.readyMap);
        this.readyMap.clear();
        return this.readyMapCopy;
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized void close() {
        this.open = false;
        if (this.inUse) {
            this.notifyAll();
        } else {
            this.finishClose();
        }
    }

    public synchronized void addToReadyInputStreams(InputStream inputStream) throws IOException {
        if (!this.open) {
            throw new IOException("This VirtualSelector is closed.");
        }
        this.readyMap.put(inputStream, this.attachmentMap.get(inputStream));
        this.notifyAll();
    }

    public synchronized void remove(InputStream inputStream) throws IOException {
        this.removableStreams.add(inputStream);
    }

    public synchronized void waitUntilEmpty() {
        while (!this.readyMap.isEmpty()) {
            try {
                log.debug((Object)"waiting until empty");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        log.debug((Object)"empty");
    }

    protected void finishClose() {
        this.attachmentMap.clear();
        this.readyMap.clear();
        this.readyMapCopy.clear();
        this.removableStreams.clear();
        this.closed = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

