/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.MarshalException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.ServerAddress;
import org.jboss.remoting.transport.socket.SocketWrapper;
import org.jboss.util.propertyeditor.PropertyEditors;

public class MicroSocketClientInvoker
extends RemoteClientInvoker {
    protected InetAddress addr;
    protected int port;
    public static final String TCP_NODELAY_FLAG = "enableTcpNoDelay";
    public static final String MAX_POOL_SIZE_FLAG = "clientMaxPoolSize";
    public static final String CLIENT_SOCKET_CLASS_FLAG = "clientSocketClass";
    public static final boolean TCP_NODELAY_DEFAULT = false;
    protected boolean shouldCheckConnection = false;
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    protected boolean enableTcpNoDelay = false;
    protected String clientSocketClassName = (class$org$jboss$remoting$transport$socket$ClientSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ClientSocketWrapper = MicroSocketClientInvoker.class$("org.jboss.remoting.transport.socket.ClientSocketWrapper")) : class$org$jboss$remoting$transport$socket$ClientSocketWrapper).getName();
    private Constructor clientSocketConstructor = null;
    protected Class clientSocketClass = null;
    public static final int MAX_RETRIES = 30;
    public long usedPooled = 0L;
    public Object usedPoolLock = new Object();
    protected int numberOfRetries = 30;
    public static final int MAX_CALL_RETRIES = 3;
    protected int numberOfCallRetries = 3;
    protected LinkedList pool = null;
    protected ServerAddress address;
    protected static final Map connectionPools = new HashMap();
    public static final int MAX_POOL_SIZE = 50;
    protected int maxPoolSize = 50;
    private boolean reuseAddress = true;
    static int counter = 0;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ClientSocketWrapper;
    static /* synthetic */ Class class$java$net$Socket;

    public MicroSocketClientInvoker(InvokerLocator locator) throws IOException {
        this(locator, null);
    }

    public MicroSocketClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            this.log.error((Object)"Error setting up socket client invoker.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    protected void setup() throws Exception {
        this.addr = InetAddress.getByName(this.locator.getHost());
        this.port = this.locator.getPort();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.configuration);
        PropertyEditors.mapJavaBeanProperties((Object)this, (Properties)props, (boolean)false);
        this.configureParameters();
        this.address = this.createServerAddress();
    }

    protected ServerAddress createServerAddress() {
        return new ServerAddress(this.addr.getHostAddress(), this.port, this.enableTcpNoDelay, -1);
    }

    protected void configureParameters() {
        Map params = this.configuration;
        if (params != null) {
            String value;
            Object val = params.get(TCP_NODELAY_FLAG);
            if (val != null) {
                try {
                    boolean bVal;
                    this.enableTcpNoDelay = bVal = Boolean.valueOf((String)val).booleanValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::enableTcpNoDelay to: " + this.enableTcpNoDelay));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert enableTcpNoDelay value of " + val + " to a boolean value."));
                }
            }
            if ((val = params.get(MAX_POOL_SIZE_FLAG)) != null) {
                try {
                    int nVal;
                    this.maxPoolSize = nVal = Integer.valueOf((String)val).intValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::maxPoolSize to: " + this.maxPoolSize));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert clientMaxPoolSize value of " + val + " to a int value."));
                }
            }
            if ((val = params.get(CLIENT_SOCKET_CLASS_FLAG)) != null && (value = (String)val).length() > 0) {
                this.clientSocketClassName = value;
                this.log.debug((Object)("Setting ClientSocket class name to: " + this.clientSocketClassName));
            }
            if ((val = params.get("socket.check_connection")) != null && (value = (String)val).length() > 0) {
                this.shouldCheckConnection = Boolean.valueOf(value);
            }
        }
    }

    public boolean checkingConnection() {
        return this.shouldCheckConnection;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.reuseAddress = reuse;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    protected synchronized void handleConnect() throws ConnectionFailedException {
        this.initPool();
    }

    protected synchronized void handleDisconnect() {
        MicroSocketClientInvoker.clearPools();
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        int x;
        Object response = null;
        long start = System.currentTimeMillis();
        SocketWrapper socketWrapper = null;
        SocketException sockEx = null;
        for (x = 0; x < this.numberOfCallRetries; ++x) {
            try {
                socketWrapper = this.getConnection();
            }
            catch (Exception e) {
                throw new CannotConnectException("Can not get connection to server.  Problem establishing socket connection for locator - " + this.locator, e);
            }
            long end = System.currentTimeMillis() - start;
            getSocketTime += end;
            try {
                int version = Version.getDefaultVersion();
                boolean performVersioning = Version.performVersioning();
                OutputStream outputStream = socketWrapper.getOutputStream();
                if (performVersioning) {
                    this.writeVersion(outputStream, version);
                }
                this.versionedWrite(outputStream, marshaller, invocation, version);
                end = System.currentTimeMillis() - start;
                writeTime += end;
                start = System.currentTimeMillis();
                InputStream inputStream = socketWrapper.getInputStream();
                if (performVersioning && (version = this.readVersion(inputStream)) == -1) {
                    throw new SocketException();
                }
                response = this.versionedRead(inputStream, unmarshaller, version);
                end = System.currentTimeMillis() - start;
                readTime += end;
                break;
            }
            catch (SocketException sex) {
                this.log.debug((Object)sex);
                try {
                    socketWrapper.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (x == this.numberOfCallRetries - 2) {
                    this.flushConnectionPool();
                }
                sockEx = sex;
                continue;
            }
            catch (Exception ex) {
                try {
                    socketWrapper.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                return this.handleException(ex, socketWrapper);
            }
        }
        if (x >= this.numberOfCallRetries) {
            this.handleException(sockEx, socketWrapper);
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxPoolSize) {
                this.pool.add(socketWrapper);
                Object object = this.usedPoolLock;
                synchronized (object) {
                    --this.usedPooled;
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Pool was already full, will close the connection");
            }
            try {
                socketWrapper.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Response: " + response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushConnectionPool() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            while (this.pool != null) {
                if (this.pool.size() <= 0) return;
                SocketWrapper socketWrapper = (SocketWrapper)this.pool.removeFirst();
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
    }

    protected Object handleException(Exception ex, SocketWrapper socketWrapper) throws ClassNotFoundException, MarshalException {
        this.log.error((Object)"Got marshalling exception, exiting", (Throwable)ex);
        if (ex instanceof ClassNotFoundException) {
            this.log.error((Object)"Error loading classes from remote call result.", (Throwable)ex);
            throw (ClassNotFoundException)ex;
        }
        throw new MarshalException("Failed to communicate.  Problem during marshalling/unmarshalling", ex);
    }

    private Object versionedRead(InputStream inputStream, UnMarshaller unmarshaller, int version) throws IOException, ClassNotFoundException {
        switch (version) {
            case 1: 
            case 2: {
                return unmarshaller.read(inputStream, null);
            }
        }
        throw new IOException("Can not read data for version " + version + ".  Supported versions: " + 1 + ", " + 2);
    }

    private void versionedWrite(OutputStream outputStream, Marshaller marshaller, Object invocation, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: {
                marshaller.write(invocation, outputStream);
                return;
            }
        }
        throw new IOException("Can not write data for version " + version + ".  Supported versions: " + 1 + ", " + 2);
    }

    private int readVersion(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    private void writeVersion(OutputStream outputStream, int version) throws IOException {
        outputStream.write(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(ServerAddress sa) {
        try {
            LinkedList thepool = (LinkedList)connectionPools.get(sa);
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    SocketWrapper socketWrapper = (SocketWrapper)thepool.removeFirst();
                    try {
                        socketWrapper.close();
                        socketWrapper = null;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPools() {
        Map map = connectionPools;
        synchronized (map) {
            Iterator it = connectionPools.keySet().iterator();
            while (it.hasNext()) {
                ServerAddress sa = (ServerAddress)it.next();
                MicroSocketClientInvoker.clearPool(sa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        Map map = connectionPools;
        synchronized (map) {
            this.pool = (LinkedList)connectionPools.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                connectionPools.put(this.address, this.pool);
            }
        }
    }

    public void setNumberOfCallRetries(int numberOfCallRetries) {
        this.numberOfCallRetries = numberOfCallRetries < 1 ? 3 : numberOfCallRetries;
    }

    public int getNumberOfCallRetries() {
        return this.numberOfCallRetries;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries < 1 ? 30 : numberOfRetries;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketWrapper getConnection() throws Exception {
        SocketWrapper pooled = null;
        for (int i = 0; i < this.numberOfRetries; ++i) {
            Object object = this.pool;
            synchronized (object) {
                if (this.pool.size() > 0) {
                    pooled = this.getPooledConnection();
                }
            }
            object = this.usedPoolLock;
            synchronized (object) {
                if (pooled != null) {
                    ++this.usedPooled;
                    break;
                }
                if (this.usedPooled < (long)this.maxPoolSize) {
                    Socket socket = null;
                    try {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Creating socket number " + counter++));
                        }
                        socket = this.createSocket(this.address.address, this.address.port);
                    }
                    catch (Exception ex) {
                        this.log.debug((Object)ex);
                        if (i + 1 < this.numberOfRetries) {
                            Thread.sleep(1L);
                            continue;
                        }
                        throw ex;
                    }
                    socket.setTcpNoDelay(this.address.enableTcpNoDelay);
                    socket.setReuseAddress(this.reuseAddress);
                    pooled = this.createClientSocket(socket, this.address.timeout, this.getLocator().getParameters());
                    ++this.usedPooled;
                    break;
                }
            }
            Thread.sleep(1000L);
        }
        if (pooled == null) {
            throw new SocketException("Can not obtain client socket connection from pool.  Have waited " + this.numberOfRetries + " seconds for available connection (" + this.usedPooled + " in use)");
        }
        return pooled;
    }

    protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.clientSocketConstructor == null) {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (this.clientSocketClass == null) {
                this.clientSocketClass = classLoader.loadClass(this.clientSocketClassName);
            }
            this.clientSocketConstructor = this.clientSocketClass.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = MicroSocketClientInvoker.class$("java.net.Socket")) : class$java$net$Socket);
        }
        SocketWrapper clientSocketWrapper = null;
        clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket);
        return clientSocketWrapper;
    }

    protected Socket createSocket(String address, int port) throws IOException {
        return new Socket(address, port);
    }

    protected SocketWrapper getPooledConnection() {
        SocketWrapper socketWrapper = null;
        while (this.pool.size() > 0) {
            socketWrapper = (SocketWrapper)this.pool.removeFirst();
            try {
                if (socketWrapper == null) continue;
                if (this.shouldCheckConnection) {
                    socketWrapper.checkConnection();
                    return socketWrapper;
                }
                return socketWrapper;
            }
            catch (Exception ex) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Couldn't reuse connection from pool");
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

