/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ServerAddress
implements Serializable {
    private static final long serialVersionUID = -7206359745950445445L;
    public String address;
    public int port;
    public boolean enableTcpNoDelay = false;
    public int timeout = 60000;
    private transient int hashCode;

    public ServerAddress(String address, int port, boolean enableTcpNoDelay, int timeout) {
        this.address = address;
        this.port = port;
        this.enableTcpNoDelay = enableTcpNoDelay;
        this.hashCode = address.hashCode() + port;
        if (enableTcpNoDelay) {
            ++this.hashCode;
        }
        if (timeout >= 0) {
            this.timeout = timeout;
        }
    }

    public String toString() {
        return "[address:" + this.address + ",port:" + this.port + ",enableTcpNoDelay:" + this.enableTcpNoDelay + "]";
    }

    public boolean equals(Object obj) {
        try {
            ServerAddress o = (ServerAddress)obj;
            if (this.port != o.port) {
                return false;
            }
            if (!this.address.equals(o.address)) {
                return false;
            }
            return this.enableTcpNoDelay == o.enableTcpNoDelay;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.hashCode = this.address.hashCode() + this.port;
        if (this.enableTcpNoDelay) {
            ++this.hashCode;
        }
    }
}

