/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslrmi;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class SerializableSSLClientSocketFactory
extends RemotingRMIClientSocketFactory {
    private static final long serialVersionUID = 3242156275483606618L;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$sslrmi$SerializableSSLClientSocketFactory == null ? (class$org$jboss$remoting$transport$sslrmi$SerializableSSLClientSocketFactory = SerializableSSLClientSocketFactory.class$("org.jboss.remoting.transport.sslrmi.SerializableSSLClientSocketFactory")) : class$org$jboss$remoting$transport$sslrmi$SerializableSSLClientSocketFactory));
    private static HashMap configMaps = new HashMap();
    private static Map socketFactories = new HashMap();
    private Map configuration;
    private InvokerLocator invokerLocator;
    static /* synthetic */ Class class$org$jboss$remoting$transport$sslrmi$SerializableSSLClientSocketFactory;

    static void addLocalConfiguration(InvokerLocator invokerLocator, Map localConfig) {
        configMaps.put(new ComparableHolder(invokerLocator), localConfig);
    }

    public SerializableSSLClientSocketFactory(InvokerLocator invokerLocator, int timeout, Map configuration) {
        super(null, invokerLocator.getHost(), timeout);
        this.invokerLocator = invokerLocator;
        this.configuration = new HashMap(configuration);
    }

    public Socket createSocket(String host, int port) throws IOException {
        ComparableHolder holder = new ComparableHolder(this.invokerLocator);
        if (!configMaps.containsKey(holder)) {
            return null;
        }
        this.socketFactory = (SocketFactory)socketFactories.get(this);
        if (this.socketFactory == null) {
            try {
                Object obj;
                HashMap tempConfig = new HashMap(this.configuration);
                Map localConfig = (Map)configMaps.get(holder);
                if (localConfig != null) {
                    tempConfig.putAll(localConfig);
                }
                if (tempConfig.containsKey("customSocketFactory")) {
                    this.socketFactory = (SocketFactory)tempConfig.get("customSocketFactory");
                } else {
                    SSLSocketBuilder socketBuilder = new SSLSocketBuilder(tempConfig);
                    socketBuilder.setUseSSLSocketFactory(false);
                    this.socketFactory = socketBuilder.createSSLSocketFactory();
                }
                socketFactories.put(this, this.socketFactory);
                if (localConfig != null && (obj = localConfig.get("handshakeCompletedListener")) != null) {
                    this.configuration.put("handshakeCompletedListener", obj);
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new RuntimeException("Unable to create customized SSL socket factory", e);
            }
        }
        Socket s = super.createSocket(host, port);
        this.socketFactory = null;
        Object obj = this.configuration.get("handshakeCompletedListener");
        if (obj != null && obj instanceof HandshakeCompletedListener) {
            SSLSocket sslSocket = (SSLSocket)s;
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            this.establishHandshake(sslSocket, listener);
        }
        return s;
    }

    private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener) throws IOException {
        HandshakeRepeater repeater = new HandshakeRepeater(listener);
        sslSocket.addHandshakeCompletedListener(repeater);
        sslSocket.getSession();
        repeater.waitForHandshake();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ComparableHolder {
        private String protocol;
        private String host;
        private int port;
        private int hashCode;

        public ComparableHolder(InvokerLocator invokerLocator) {
            this.protocol = invokerLocator.getProtocol().toLowerCase();
            this.host = invokerLocator.getHost();
            this.port = invokerLocator.getPort();
            this.hashCode = this.protocol.hashCode() * this.host.hashCode() * this.port;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ComparableHolder)) {
                return false;
            }
            ComparableHolder holder = (ComparableHolder)obj;
            return this.protocol.equals(holder.protocol.toLowerCase()) && this.host.equals(holder.host) && this.port == holder.port;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

