/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.model.DataModel;
import org.jboss.seam.core.Manager;
import org.jboss.seam.ui.HTML;
import org.jboss.seam.ui.UIAction;
import org.jboss.seam.ui.UIConversationId;
import org.jboss.seam.ui.UIConversationPropagation;
import org.jboss.seam.ui.UISelection;
import org.jboss.seam.ui.UITaskId;

public class HtmlLink
extends HtmlOutputLink {
    public static final String COMPONENT_TYPE = "org.jboss.seam.ui.HtmlLink";
    private String view;
    private String action;
    private String pageflow;
    private String style;
    private String buttonClass;
    private String propagation = "default";
    private String fragment;

    private UISelection getSelection() {
        UIData parentUIData = this.getParentUIData();
        if (parentUIData != null) {
            if (parentUIData.getValue() instanceof DataModel) {
                String dataModelExpression = parentUIData.getValueBinding("value").getExpressionString();
                String dataModelName = dataModelExpression.substring(2, dataModelExpression.length() - 1);
                UISelection uiSelection = new UISelection();
                uiSelection.setDataModel(dataModelName);
                return uiSelection;
            }
            return null;
        }
        return null;
    }

    public UIData getParentUIData() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof UIData) {
                return (UIData)parent;
            }
            if (parent instanceof UIComponent) {
                continue;
            }
            return null;
        }
        return null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UISelection uiSelection;
        ValueBinding taskInstanceValueBinding;
        ResponseWriter writer = context.getResponseWriter();
        if ("button".equals(this.style)) {
            writer.startElement("input", (UIComponent)this);
            writer.writeAttribute("type", (Object)"button", null);
        } else {
            writer.startElement("a", (UIComponent)this);
        }
        writer.writeAttribute("id", (Object)this.getClientId(context), null);
        String viewId = this.view == null ? context.getViewRoot().getViewId() : this.view;
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        String encodedUrl = context.getExternalContext().encodeActionURL(url);
        String characterEncoding = context.getResponseWriter().getCharacterEncoding();
        boolean first = true;
        for (Object child : this.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, (UIParameter)child, first);
            first = false;
        }
        ValueBinding actionValueBinding = this.getValueBinding("action");
        if (actionValueBinding != null || this.action != null) {
            UIAction uiAction = new UIAction();
            uiAction.setValueBinding("action", actionValueBinding);
            uiAction.setAction(this.action);
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiAction, first);
            first = false;
        }
        if (("default".equals(this.propagation) || "join".equals(this.propagation) || "nest".equals(this.propagation) || "end".equals(this.propagation)) && Manager.instance().isLongRunningConversation()) {
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, new UIConversationId(), first);
            first = false;
        }
        if ("join".equals(this.propagation) || "nest".equals(this.propagation) || "begin".equals(this.propagation) || "end".equals(this.propagation)) {
            UIConversationPropagation uiPropagation = new UIConversationPropagation();
            uiPropagation.setType(this.propagation);
            uiPropagation.setPageflow(this.pageflow);
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiPropagation, first);
            first = false;
        }
        if ((taskInstanceValueBinding = this.getValueBinding("taskInstance")) != null) {
            UITaskId uiTaskId = new UITaskId();
            uiTaskId.setValueBinding("taskInstance", taskInstanceValueBinding);
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiTaskId, first);
            first = false;
        }
        if ((uiSelection = this.getSelection()) != null) {
            encodedUrl = encodedUrl + this.getParameterString(characterEncoding, uiSelection, first);
            first = false;
        }
        if (this.fragment != null) {
            encodedUrl = encodedUrl + '#' + this.fragment;
        }
        if ("button".equals(this.style)) {
            writer.writeAttribute("onclick", (Object)("location.href='" + encodedUrl + "'"), null);
        } else {
            writer.writeAttribute("href", (Object)encodedUrl, null);
            HTML.renderHTMLAttributes(writer, (UIComponent)this, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
        }
        Object label = this.getValue();
        if (label != null) {
            if ("button".equals(this.style)) {
                writer.writeAttribute("value", label, null);
                if (this.buttonClass != null) {
                    writer.writeAttribute("class", (Object)this.buttonClass, null);
                }
                writer.flush();
            } else {
                writer.flush();
                writer.writeText(label, null);
            }
        } else {
            writer.flush();
        }
    }

    private String getParameterString(String characterEncoding, UIParameter param, boolean first) throws UnsupportedEncodingException {
        Object value = param.getValue();
        String strValue = value == null ? "" : value.toString();
        String encoded = characterEncoding == null ? URLEncoder.encode(strValue) : URLEncoder.encode(strValue, characterEncoding);
        return (first ? (char)'?' : '&') + param.getName() + '=' + encoded;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String viewId) {
        this.view = viewId;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.view = (String)values[1];
        this.pageflow = (String)values[2];
        this.propagation = (String)values[3];
        this.action = (String)values[4];
        this.style = (String)values[5];
        this.buttonClass = (String)values[6];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.view, this.pageflow, this.propagation, this.action, this.style, this.buttonClass};
        return values;
    }

    public String getPageflow() {
        return this.pageflow;
    }

    public String getPropagation() {
        return this.propagation;
    }

    public void setPageflow(String pageflow) {
        this.pageflow = pageflow;
    }

    public void setPropagation(String propagation) {
        this.propagation = propagation;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getLinkStyle() {
        return this.style;
    }

    public void setLinkStyle(String style) {
        this.style = style;
    }

    public String getButtonClass() {
        return this.buttonClass;
    }

    public void setButtonClass(String buttonClass) {
        this.buttonClass = buttonClass;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }
}

