/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.facelet;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import org.jboss.seam.actionparam.MethodExpressionParser;
import org.jboss.seam.ui.facelet.SeamExpressionFactory;

class MethodExpressionHelper
implements Serializable {
    private String expWithParams;
    private boolean isStringLiteral = false;
    private MethodExpressionParser parser;
    private MethodExpression methodExp;
    private boolean expressionInitializedInCtor = false;
    private String hashString;

    MethodExpressionHelper(ELContext elContext, MethodExpressionParser parser) {
        this.expWithParams = parser.getUnparsedExpression();
        this.parser = parser;
        if (MethodExpressionParser.isStringLiteral((String)this.expWithParams)) {
            this.setMethodExpression(elContext, new Class[0]);
            this.isStringLiteral = true;
            this.expressionInitializedInCtor = true;
            return;
        }
        if (parser.getParams().length == 0) {
            this.setMethodExpression(elContext, new Class[0]);
            this.expressionInitializedInCtor = true;
        }
    }

    boolean isLiteralText() {
        return this.isStringLiteral;
    }

    MethodInfo getMethodInfo(ELContext elContext) {
        if (this.methodExp == null) {
            return new PartialMethodInfo(this.parser.getMethodName());
        }
        return this.methodExp.getMethodInfo(elContext);
    }

    Object invokeTheExpression(ELContext elContext) {
        if (this.methodExp == null) {
            this.setMethodExpression(elContext, this.findParamTypes(elContext));
        }
        Object[] evaluatedParams = this.evaluateParams(elContext);
        return this.methodExp.invoke(elContext, evaluatedParams);
    }

    MethodExpression getExpression() {
        return this.methodExp;
    }

    private Object[] evaluateParams(ELContext elContext) {
        String[] params = this.parser.getParams();
        Object[] results = new Object[params.length];
        for (int i = 0; i < results.length; ++i) {
            String param = params[i].trim();
            if (MethodExpressionParser.isQuotedString((String)param)) {
                results[i] = param.substring(1, param.length() - 1);
                continue;
            }
            ValueExpression ve = SeamExpressionFactory.getFaceletsExpressionFactory().createValueExpression(elContext, "#{" + param + "}", Object.class);
            results[i] = ve.getValue(elContext);
        }
        return results;
    }

    private Class[] findParamTypes(ELContext elContext) {
        if (this.parser.getParams().length == 0) {
            return new Class[0];
        }
        String expression = "#{" + this.parser.getBaseExpression() + "}";
        ValueExpression ve = SeamExpressionFactory.getFaceletsExpressionFactory().createValueExpression(elContext, expression, Object.class);
        Object obj = ve.getValue(elContext);
        Method[] publicMethods = obj.getClass().getMethods();
        Method methodMatch = null;
        for (int i = 0; i < publicMethods.length; ++i) {
            if (!this.methodMatches(publicMethods[i])) continue;
            if (methodMatch != null) {
                throw new ELException("More than one method matched " + this.expWithParams + ". Method name or number of params must be unique.");
            }
            methodMatch = publicMethods[i];
        }
        if (methodMatch == null) {
            throw new ELException("No method found for expression " + this.expWithParams + ".  Method name and number of params must match.");
        }
        return methodMatch.getParameterTypes();
    }

    private boolean methodMatches(Method method) {
        return method.getName().equals(this.parser.getMethodName()) && method.getParameterTypes().length == this.parser.getParams().length;
    }

    private void setMethodExpression(ELContext elContext, Class[] paramTypes) {
        this.methodExp = SeamExpressionFactory.getFaceletsExpressionFactory().createMethodExpression(elContext, this.parser.getCombinedExpression(), String.class, paramTypes);
    }

    private String getHashString() {
        if (this.hashString == null) {
            this.hashString = this.parser.getBaseExpression() + "." + this.parser.getMethodName() + "." + this.parser.getParams().length;
        }
        return this.hashString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.expressionInitializedInCtor) {
            return this.methodExp.equals(object);
        }
        if (!(object instanceof MethodExpressionHelper)) {
            return false;
        }
        MethodExpressionHelper exp = (MethodExpressionHelper)object;
        return this.getHashString().equals(exp.getHashString());
    }

    public int hashCode() {
        if (this.expressionInitializedInCtor) {
            return this.methodExp.hashCode();
        }
        return this.getHashString().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartialMethodInfo
    extends MethodInfo {
        private PartialMethodInfo(String methodName) {
            super(methodName, Object.class, new Class[0]);
        }

        public Class<?>[] getParamTypes() {
            throw new IllegalStateException("paramTypes unknown until MethodExpression is invoked.");
        }
    }
}

