/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.tag;

import java.io.IOException;
import java.io.Reader;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentBodyTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ui.tag.UIComponentTagBase;

public abstract class UIComponentBodyTagBase
extends UIComponentBodyTag {
    private static final Log log = LogFactory.getLog(UIComponentBodyTagBase.class);
    private String _value;
    private String _converter;

    public int doEndTag() throws JspException {
        UIComponent component;
        if (log.isWarnEnabled() && (component = this.getComponentInstance()) != null && component.getRendersChildren() && !this.isBodyContentEmpty()) {
            log.warn((Object)("Component with id '" + component.getClientId(this.getFacesContext()) + "' (" + ((Object)((Object)this)).getClass().getName() + " tag) renders it's children, but has embedded JSP or HTML code. Use the <f:verbatim> tag for nested HTML. For comments use <%/* */%> style JSP comments instead of <!-- --> style HTML comments." + "\n BodyContent:\n" + this.getBodyContent().getString().trim()));
        }
        return super.doEndTag();
    }

    private boolean isBodyContentEmpty() {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent == null) {
            return true;
        }
        try {
            int c;
            Reader reader = bodyContent.getReader();
            while ((c = reader.read()) != -1) {
                if (Character.isWhitespace((char)c)) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Error inspecting BodyContent", (Throwable)e);
            return false;
        }
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        this.setValueProperty(component, this._value);
        this.setConverterProperty(component, this._converter);
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void setConverter(String converter) {
        this._converter = converter;
    }

    protected void setIntegerProperty(UIComponent component, String propName, String value) {
        UIComponentTagBase.setIntegerProperty(this.getFacesContext(), component, propName, value);
    }

    protected void setStringProperty(UIComponent component, String propName, String value) {
        UIComponentTagBase.setStringProperty(this.getFacesContext(), component, propName, value);
    }

    protected void setBooleanProperty(UIComponent component, String propName, String value) {
        UIComponentTagBase.setBooleanProperty(this.getFacesContext(), component, propName, value);
    }

    protected void setValueProperty(UIComponent component, String value) {
        UIComponentTagBase.setValueProperty(this.getFacesContext(), component, value);
    }

    private void setConverterProperty(UIComponent component, String value) {
        UIComponentTagBase.setConverterProperty(this.getFacesContext(), component, value);
    }

    protected void setValidatorProperty(UIComponent component, String value) {
        UIComponentTagBase.setValidatorProperty(this.getFacesContext(), component, value);
    }

    protected void setActionProperty(UIComponent component, String action) {
        UIComponentTagBase.setActionProperty(this.getFacesContext(), component, action);
    }

    protected void setActionListenerProperty(UIComponent component, String actionListener) {
        UIComponentTagBase.setActionListenerProperty(this.getFacesContext(), component, actionListener);
    }

    protected void setValueChangedListenerProperty(UIComponent component, String valueChangedListener) {
        UIComponentTagBase.setValueChangedListenerProperty(this.getFacesContext(), component, valueChangedListener);
    }

    protected void setValueBinding(UIComponent component, String propName, String value) {
        UIComponentTagBase.setValueBinding(this.getFacesContext(), component, propName, value);
    }
}

