/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.tag;

import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UIComponentTagBase
extends UIComponentTag {
    private static final Log log = LogFactory.getLog(UIComponentTagBase.class);
    private String _value;
    private String _converter;
    private static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    private static final Class[] VALUE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};

    public void release() {
        super.release();
        this._value = null;
        this._converter = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        this.setValueProperty(component, this._value);
        this.setConverterProperty(component, this._converter);
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void setConverter(String converter) {
        this._converter = converter;
    }

    protected void setIntegerProperty(UIComponent component, String propName, String value) {
        UIComponentTagBase.setIntegerProperty(this.getFacesContext(), component, propName, value);
    }

    protected void setStringProperty(UIComponent component, String propName, String value) {
        UIComponentTagBase.setStringProperty(this.getFacesContext(), component, propName, value);
    }

    protected void setBooleanProperty(UIComponent component, String propName, String value) {
        UIComponentTagBase.setBooleanProperty(this.getFacesContext(), component, propName, value);
    }

    private void setValueProperty(UIComponent component, String value) {
        UIComponentTagBase.setValueProperty(this.getFacesContext(), component, value);
    }

    private void setConverterProperty(UIComponent component, String value) {
        UIComponentTagBase.setConverterProperty(this.getFacesContext(), component, value);
    }

    protected void setValidatorProperty(UIComponent component, String value) {
        UIComponentTagBase.setValidatorProperty(this.getFacesContext(), component, value);
    }

    protected void setActionProperty(UIComponent component, String action) {
        UIComponentTagBase.setActionProperty(this.getFacesContext(), component, action);
    }

    protected void setActionListenerProperty(UIComponent component, String actionListener) {
        UIComponentTagBase.setActionListenerProperty(this.getFacesContext(), component, actionListener);
    }

    protected void setValueChangedListenerProperty(UIComponent component, String valueChangedListener) {
        UIComponentTagBase.setValueChangedListenerProperty(this.getFacesContext(), component, valueChangedListener);
    }

    protected void setValueBinding(UIComponent component, String propName, String value) {
        UIComponentTagBase.setValueBinding(this.getFacesContext(), component, propName, value);
    }

    public static boolean isValueReference(String v) {
        return UIComponentTag.isValueReference((String)v);
    }

    public static void setIntegerProperty(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Integer.valueOf(value));
            }
        }
    }

    public static void setStringProperty(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, value);
            }
        }
    }

    public static void setBooleanProperty(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Boolean.valueOf(value));
            }
        }
    }

    public static void setValueProperty(FacesContext context, UIComponent component, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding("value", vb);
            } else if (component instanceof UICommand) {
                ((UICommand)component).setValue((Object)value);
            } else if (component instanceof UIParameter) {
                ((UIParameter)component).setValue((Object)value);
            } else if (component instanceof UISelectBoolean) {
                ((UISelectBoolean)component).setValue((Object)Boolean.valueOf(value));
            } else if (component instanceof UIGraphic) {
                ((UIGraphic)component).setValue((Object)value);
            } else if (component instanceof ValueHolder) {
                ((ValueHolder)component).setValue((Object)value);
            } else {
                log.error((Object)("Component " + component.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void setConverterProperty(FacesContext context, UIComponent component, String value) {
        if (value != null) {
            if (component instanceof ValueHolder) {
                if (UIComponentTagBase.isValueReference(value)) {
                    ValueBinding vb = context.getApplication().createValueBinding(value);
                    component.setValueBinding("converter", vb);
                } else {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    Converter converter = facesContext.getApplication().createConverter(value);
                    ((ValueHolder)component).setConverter(converter);
                }
            } else {
                log.error((Object)("Component " + component.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void setValidatorProperty(FacesContext context, UIComponent component, String validator) {
        if (validator != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no EditableValueHolder");
            }
            if (UIComponentTagBase.isValueReference(validator)) {
                MethodBinding mb = context.getApplication().createMethodBinding(validator, VALIDATOR_ARGS);
                ((EditableValueHolder)component).setValidator(mb);
            } else {
                log.error((Object)("Invalid expression " + validator));
            }
        }
    }

    public static void setValueBinding(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                throw new IllegalArgumentException("Attribute " + propName + " must be a value reference");
            }
        }
    }

    public static void setActionProperty(FacesContext context, UIComponent component, String action) {
        if (action != null) {
            if (!(component instanceof ActionSource)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no ActionSource");
            }
            if (UIComponentTagBase.isValueReference(action)) {
                MethodBinding mb = context.getApplication().createMethodBinding(action, null);
                ((ActionSource)component).setAction(mb);
            } else {
                log.error((Object)("Invalid expression " + action));
            }
        }
    }

    public static void setActionListenerProperty(FacesContext context, UIComponent component, String actionListener) {
        if (actionListener != null) {
            if (!(component instanceof ActionSource)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no ActionSource");
            }
            if (UIComponentTagBase.isValueReference(actionListener)) {
                MethodBinding mb = context.getApplication().createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                ((ActionSource)component).setActionListener(mb);
            } else {
                log.error((Object)("Invalid expression " + actionListener));
            }
        }
    }

    public static void setValueChangedListenerProperty(FacesContext context, UIComponent component, String valueChangedListener) {
        if (valueChangedListener != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no EditableValueHolder");
            }
            if (UIComponentTagBase.isValueReference(valueChangedListener)) {
                MethodBinding mb = context.getApplication().createMethodBinding(valueChangedListener, VALUE_LISTENER_ARGS);
                ((EditableValueHolder)component).setValueChangeListener(mb);
            } else {
                log.error((Object)("Invalid expression " + valueChangedListener));
            }
        }
    }
}

