/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.jboss.cache.CacheException;
import org.jboss.seam.core.PojoCache;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.ui.JSF;

public class UICache
extends UIComponentBase {
    private static final LogProvider log = Logging.getLogProvider(UICache.class);
    public static final String COMPONENT_FAMILY = "org.jboss.seam.ui.Cache";
    public static final String COMPONENT_TYPE = "org.jboss.seam.ui.UICache";
    private String key;
    private String region;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    private String evaluateKey(FacesContext facesContext) {
        ValueBinding keyValueBinding = this.getValueBinding("key");
        return keyValueBinding == null ? this.key : keyValueBinding.getValue(facesContext).toString();
    }

    private boolean isEnabled(FacesContext facesContext) {
        ValueBinding enabledValueBinding = this.getValueBinding("enabled");
        return enabledValueBinding == null || (Boolean)enabledValueBinding.getValue(facesContext) != false;
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter response = facesContext.getResponseWriter();
        boolean enabled = this.isEnabled(facesContext);
        if (enabled) {
            String key = this.evaluateKey(facesContext);
            String cachedContent = this.getFromCache(key);
            if (cachedContent == null) {
                log.debug((Object)("rendering from scratch: " + key));
                StringWriter stringWriter = new StringWriter();
                ResponseWriter cachingResponseWriter = response.cloneWithWriter((Writer)stringWriter);
                facesContext.setResponseWriter(cachingResponseWriter);
                JSF.renderChildren(facesContext, (UIComponent)this);
                facesContext.setResponseWriter(response);
                String output = stringWriter.getBuffer().toString();
                response.write(output);
                this.putInCache(key, output);
            } else {
                log.debug((Object)("rendering from cache: " + key));
                response.write("<!-- cached content for: ");
                response.write(key);
                response.write(" -->");
                response.write(cachedContent);
                response.write("<!-- end of cached content -->");
            }
        } else {
            JSF.renderChildren(facesContext, (UIComponent)this);
        }
    }

    private void putInCache(String key, String content) {
        try {
            PojoCache.instance().put(this.region, (Object)key, (Object)content);
        }
        catch (CacheException ce) {
            log.error((Object)"error accessing cache", (Throwable)ce);
        }
    }

    private String getFromCache(String key) {
        try {
            return (String)PojoCache.instance().get(this.region, (Object)key);
        }
        catch (CacheException ce) {
            log.error((Object)"error accessing cache", (Throwable)ce);
            return null;
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.key = (String)values[1];
        this.region = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.key, this.region};
        return values;
    }
}

