/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.jboss.seam.ui.JSF;

public class UISelectDate
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.jboss.seam.ui.UISelectDate";
    public static final String COMPONENT_FAMILY = "org.jboss.seam.ui.SelectDate";
    private String forField;
    private String dateFormat = "MM/dd/yyyy";
    private int startYear = -1;
    private int endYear = -1;

    public String getDateFormat() {
        ValueBinding vb = this.getValueBinding("dateFormat");
        return vb != null ? JSF.getStringValue(this.getFacesContext(), vb) : this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getFor() {
        ValueBinding vb = this.getValueBinding("for");
        return vb != null ? JSF.getStringValue(this.getFacesContext(), vb) : this.forField;
    }

    public void setFor(String forField) {
        this.forField = forField;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.forField = (String)values[1];
        this.dateFormat = (String)values[2];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.forField, this.dateFormat};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIComponent forComponent = this.findComponent(this.getFor());
        if (forComponent == null) {
            throw new IllegalStateException("could not find component with id: " + this.getFor());
        }
        this.writeScript(context);
        ResponseWriter response = context.getResponseWriter();
        response.startElement("span", (UIComponent)this);
        response.writeAttribute("onclick", (Object)("__selectDate('" + forComponent.getClientId(context) + "', '" + forComponent.getClientId(context) + "');"), null);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter response = context.getResponseWriter();
        response.endElement("span");
        response.flush();
        super.encodeEnd(context);
    }

    public void writeScript(FacesContext context) throws IOException {
        Map request = context.getExternalContext().getRequestMap();
        if (request.get("SELECTDATE_SCRIPT") != null) {
            return;
        }
        request.put("SELECTDATE_SCRIPT", null);
        ResponseWriter response = context.getResponseWriter();
        this.writeLocaleInformation(response, context.getViewRoot().getLocale());
        response.startElement("script", null);
        response.writeAttribute("type", (Object)"text/javascript", null);
        response.writeAttribute("src", (Object)(context.getExternalContext().getRequestContextPath() + "/seam/resource/web" + "/date/calendar.js"), null);
        response.endElement("script");
    }

    private void writeLocaleInformation(ResponseWriter response, Locale locale) throws IOException {
        response.startElement("script", null);
        response.writeAttribute("type", (Object)"text/javascript", null);
        Calendar cal = Calendar.getInstance(locale);
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        response.write("\r");
        response.write("var CAL_DAYS_SHORT = '" + this.commaSeparate(symbols.getShortWeekdays(), 2) + "';\r");
        response.write("var CAL_DAYS_MEDIUM = '" + this.commaSeparate(symbols.getShortWeekdays()) + "';\r");
        response.write("var CAL_DAYS_LONG = '" + this.commaSeparate(symbols.getWeekdays()) + "';\r");
        response.write("var CAL_MONTHS_MEDIUM = '" + this.commaSeparate(symbols.getShortMonths()) + "';\r");
        response.write("var CAL_MONTHS_LONG = '" + this.commaSeparate(symbols.getMonths()) + "';\r");
        response.write("var CAL_FIRST_DAY_OF_WEEK = " + (cal.getFirstDayOfWeek() - 1) + ";\r");
        response.write("var CAL_DATE_FORMAT = '" + this.getDateFormat() + "';\r");
        if (this.startYear != -1 && this.endYear != -1) {
            response.write("var CAL_START_YEAR = " + this.startYear + ";\r");
            response.write("var CAL_END_YEAR = " + this.endYear + ";\r");
        }
        response.endElement("script");
    }

    private String commaSeparate(String[] values) {
        return this.commaSeparate(values, -1);
    }

    private String commaSeparate(String[] values, int maxLength) {
        StringBuilder sb = new StringBuilder();
        for (String val : values) {
            if ("".equals(val)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(this.limitLength(val, maxLength));
        }
        return sb.toString();
    }

    private String limitLength(String source, int maxLength) {
        if (maxLength < 0 || maxLength > source.length()) {
            return source;
        }
        return source.substring(0, maxLength);
    }
}

