/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.facelet;

import com.sun.facelets.Facelet;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Renderer;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.ui.JSF;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.STATELESS)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.renderer")
@Install(value=true, precedence=0, classDependencies={"com.sun.facelets.Facelet"})
public class FaceletsRenderer
extends Renderer {
    public String render(String viewId) {
        Context context = new Context(viewId);
        try {
            context.wrap();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.renderFacelet(facesContext, this.faceletForURL(this.resourceURL(viewId)));
            String string = context.getWrittenOutput();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            context.unwrap();
        }
    }

    protected URL resourceURL(String viewId) {
        URL url = Resources.getResource((String)viewId);
        if (url == null) {
            throw new IllegalArgumentException("resource doesn't exist: " + viewId);
        }
        return url;
    }

    protected Facelet faceletForURL(URL url) throws IOException {
        return new DefaultFaceletFactory((Compiler)new SAXCompiler(), (ResourceResolver)new DefaultResourceResolver()).getFacelet(url);
    }

    protected void renderFacelet(FacesContext facesContext, Facelet facelet) throws IOException {
        UIViewRoot root = facesContext.getViewRoot();
        facelet.apply(facesContext, (UIComponent)root);
        JSF.renderChildren(facesContext, (UIComponent)root);
    }

    private class Context {
        private String viewId;
        private ClassLoader originalClassLoader;
        private ResponseWriter originalResponseWriter;
        private UIViewRoot originalViewRoot;
        private StringWriter writer = new StringWriter();

        public Context(String viewId) {
            this.viewId = viewId;
        }

        public Context wrap() {
            this.originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (FacesContext.getCurrentInstance() == null) {
                MockFacesContext mockFacesContext = new MockFacesContext((ExternalContext)new MockExternalContext()).setCurrent();
                mockFacesContext.createViewRoot();
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.originalResponseWriter = facesContext.getResponseWriter();
            facesContext.setResponseWriter(facesContext.getRenderKit().createResponseWriter((Writer)this.writer, null, null));
            this.originalViewRoot = facesContext.getViewRoot();
            UIViewRoot viewRoot = new UIViewRoot();
            viewRoot.setRenderKitId(facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext));
            viewRoot.setViewId(this.viewId);
            viewRoot.setLocale(this.originalViewRoot.getLocale());
            facesContext.setViewRoot(viewRoot);
            return this;
        }

        public void unwrap() {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (this.originalResponseWriter != null) {
                facesContext.setResponseWriter(this.originalResponseWriter);
            }
            if (this.originalViewRoot != null) {
                facesContext.setViewRoot(this.originalViewRoot);
            }
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }

        public String getWrittenOutput() {
            return this.writer.getBuffer().toString();
        }
    }
}

