/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.IOException;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.servlet.AbstractResource;
import org.jboss.seam.ui.graphicImage.DynamicImageStore;

@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.ui.graphicImage.dynamicImageResource")
@Install(precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class DynamicImageResource
extends AbstractResource {
    public static final String DYNAMIC_IMAGE_RESOURCE_PATH = "/seam/resource/dynamicImage";
    private static final String RESOURCE_PATH = "/dynamicImage";

    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo().substring(this.getResourcePath().length() + 1, request.getPathInfo().lastIndexOf("."));
        HttpSession session = request.getSession(true);
        Lifecycle.setPhaseId((PhaseId)PhaseId.INVOKE_APPLICATION);
        Lifecycle.setServletRequest((ServletRequest)request);
        Lifecycle.beginRequest((ServletContext)this.getServletContext(), (HttpSession)session, (ServletRequest)request);
        Manager.instance().restoreConversation(request.getParameterMap());
        Lifecycle.resumeConversation((HttpSession)session);
        Manager.instance().handleConversationPropagation(request.getParameterMap());
        try {
            DynamicImageStore.ImageWrapper image = DynamicImageStore.instance().remove(pathInfo);
            if (image != null) {
                response.setContentType(image.getContentType().getMimeType());
                response.setStatus(200);
                response.setContentLength(image.getImage().length);
                ServletOutputStream os = response.getOutputStream();
                os.write(image.getImage());
                os.flush();
            } else {
                response.sendError(404);
            }
            Manager.instance().endRequest(ContextAdaptor.getSession((HttpSession)session));
            Lifecycle.endRequest((HttpSession)session);
        }
        catch (Exception e) {
            Lifecycle.endRequest();
        }
        finally {
            Lifecycle.setServletRequest(null);
            Lifecycle.setPhaseId(null);
        }
    }
}

