/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.component;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.el.ValueExpression;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;

public abstract class UIFileUpload
extends UIInput {
    private String localContentType;
    private String localFileName;
    private Integer localFileSize;
    private InputStream localInputStream;

    public void processUpdates(FacesContext context) {
        ValueExpression dataBinding;
        if (this.getLocalInputStream() != null && (dataBinding = this.getValueExpression("data")) != null) {
            ValueExpression valueExpression;
            Class clazz = dataBinding.getType(context.getELContext());
            if (clazz.isAssignableFrom(InputStream.class)) {
                dataBinding.setValue(context.getELContext(), (Object)this.localInputStream);
            } else if (clazz.isAssignableFrom(byte[].class)) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    while (this.localInputStream.available() > 0) {
                        bos.write(this.localInputStream.read());
                        dataBinding.setValue(context.getELContext(), (Object)bos.toByteArray());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.getLocalContentType() != null && (valueExpression = this.getValueExpression("contentType")) != null) {
                valueExpression.setValue(context.getELContext(), (Object)this.getLocalContentType());
            }
            if (this.getLocalFileName() != null && (valueExpression = this.getValueExpression("fileName")) != null) {
                valueExpression.setValue(context.getELContext(), (Object)this.getLocalFileName());
            }
            if (this.getLocalFileSize() != null && (valueExpression = this.getValueExpression("fileSize")) != null) {
                valueExpression.setValue(context.getELContext(), (Object)this.getLocalFileSize());
            }
        }
    }

    public String getLocalContentType() {
        return this.localContentType;
    }

    public void setLocalContentType(String localContentType) {
        this.localContentType = localContentType;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
    }

    public Integer getLocalFileSize() {
        return this.localFileSize;
    }

    public void setLocalFileSize(Integer localFileSize) {
        this.localFileSize = localFileSize;
    }

    public InputStream getLocalInputStream() {
        return this.localInputStream;
    }

    public void setLocalInputStream(InputStream localInputStream) {
        this.localInputStream = localInputStream;
    }

    public abstract void setAccept(String var1);

    public abstract String getAccept();

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);
}

