/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.ui.graphicImage.Image;

@Name(value="org.jboss.seam.ui.graphicImage.graphicImageStore")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
@BypassInterceptors
public class GraphicImageStore
extends AbstractMutable
implements Serializable {
    private Log log = Logging.getLog(GraphicImageStore.class);
    private Map<String, ImageWrapper> store = new HashMap<String, ImageWrapper>();
    private int index = 0;

    public String put(ImageWrapper image) {
        return this.put(image, null);
    }

    public String put(ImageWrapper image, String key) {
        if (key == null) {
            key = "org.jboss.seam.ui.GraphicImageStore." + this.index;
            ++this.index;
        }
        this.store.put(key, image);
        this.setDirty();
        this.log.debug((Object)"Put image into to session with key #0", new Object[]{key});
        return key;
    }

    public ImageWrapper get(String key) {
        this.log.debug((Object)"Get image into to session with key #0", new Object[]{key});
        ImageWrapper image = this.store.get(key);
        return image;
    }

    public ImageWrapper remove(String key) {
        this.log.debug((Object)"Get image from session with key #0", new Object[]{key});
        ImageWrapper imageWrapper = this.store.remove(key);
        if (imageWrapper != null) {
            this.setDirty();
        }
        return imageWrapper;
    }

    public boolean contains(String key) {
        return this.store.containsKey(key);
    }

    public static GraphicImageStore instance() {
        return (GraphicImageStore)Component.getInstance(GraphicImageStore.class, (boolean)true);
    }

    public static class ImageWrapper
    implements Serializable {
        private byte[] image;
        private Image.Type contentType;

        public ImageWrapper(byte[] image, Image.Type contentType) {
            this.image = image;
            this.contentType = contentType;
        }

        public Image.Type getContentType() {
            return this.contentType;
        }

        public byte[] getImage() {
            return this.image;
        }
    }
}

