/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.ui.component.UIButton;
import org.jboss.seam.ui.util.HTML;
import org.jboss.seam.ui.util.cdk.RendererBase;

public class ButtonRendererBase
extends RendererBase {
    protected Class getComponentClass() {
        return UIButton.class;
    }

    private String getType(UIButton button) {
        if (button.getImage() == null) {
            return "button";
        }
        return "image";
    }

    private String getOnClick(UIButton button) throws IOException {
        String onclick = button.getOnclick();
        String url = button.getUrl();
        if (onclick == null) {
            onclick = "";
        } else if (onclick.length() > 0 && !onclick.endsWith(";")) {
            onclick = onclick + ";";
        }
        if (url != null) {
            onclick = onclick + "location.href='" + url + "'";
        }
        if (!button.isDisabled()) {
            return onclick;
        }
        return null;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIButton button = (UIButton)component;
        writer.startElement("input", (UIComponent)button);
        String onclick = this.getOnClick(button);
        if (!"".equals(onclick) && !button.isDisabled()) {
            writer.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        HTML.renderHTMLAttributes(writer, (UIComponent)button, HTML.BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONCLICK);
        if (button.getValue() != null) {
            writer.writeAttribute("value", button.getValue(), "value");
        }
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)true, "disabled");
        }
        writer.writeAttribute("type", (Object)this.getType(button), "type");
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("input");
    }
}

