/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBuilder {
    private String url;
    private String fragment;
    private String characterEncoding;
    private Map<String, String> parameters;

    protected UrlBuilder(String fragment) {
        this.fragment = fragment;
        this.parameters = new HashMap<String, String>();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.characterEncoding = facesContext.getResponseWriter().getCharacterEncoding();
    }

    public UrlBuilder(String url, String fragment) {
        this(fragment);
        this.setUrl(url);
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected String urlEncode(String value) throws UnsupportedEncodingException {
        return this.characterEncoding == null ? URLEncoder.encode(value) : URLEncoder.encode(value, this.characterEncoding);
    }

    protected String getFragment() {
        if (this.fragment != null && !"".equals(this.fragment)) {
            return "#" + this.fragment;
        }
        return "";
    }

    public String getEncodedUrl() {
        return this.url + this.getParametersAsString() + this.getFragment();
    }

    protected String getParametersAsString() {
        String params = "";
        for (String key : this.parameters.keySet()) {
            params = params + "&" + key + "=" + this.parameters.get(key);
        }
        if (!"".equals(params)) {
            params = "?" + params.substring(1);
        }
        return params;
    }

    protected Map<String, String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name, String value) throws UnsupportedEncodingException {
        this.parameters.put(name, this.urlEncode(value));
    }

    public void addParameter(UIParameter parameter) throws UnsupportedEncodingException {
        String value = parameter.getValue() == null ? "" : parameter.getValue().toString();
        String name = parameter.getName();
        this.addParameter(name, value);
    }
}

